/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ParameterResolver;
import io.vlingo.http.resource.RequestExecutor;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestHandler2;
import io.vlingo.http.resource.RequestObjectExecutor;
import java.util.Collections;
import java.util.function.Supplier;

public class RequestHandler1<T>
extends RequestHandler {
    final ParameterResolver<T> resolver;
    private ParamExecutor1<T> executor;

    RequestHandler1(Method method, String path, ParameterResolver<T> resolver, ErrorHandler errorHandler, MediaTypeMapper mediaTypeMapper) {
        super(method, path, Collections.singletonList(resolver), errorHandler, mediaTypeMapper);
        this.resolver = resolver;
    }

    public RequestHandler1<T> handle(Handler1<T> handler) {
        this.executor = (request, param1, mediaTypeMapper1, errorHandler1, logger1) -> RequestExecutor.executeRequest(() -> handler.execute(param1), errorHandler1, logger1);
        return this;
    }

    public <O> RequestHandler1<T> handle(ObjectHandler1<O, T> handler) {
        this.executor = (request, param1, mediaTypeMapper1, errorHandler1, logger) -> RequestObjectExecutor.executeRequest(request, mediaTypeMapper1, () -> handler.execute(param1), errorHandler1, logger);
        return this;
    }

    public RequestHandler1<T> onError(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    Completes<Response> execute(Request request, T param1, Logger logger) {
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    @Override
    protected Completes<Response> execute(Request request, Action.MappedParameters mappedParameters, Logger logger) {
        return this.execute(request, this.resolver.apply(request, mappedParameters), logger);
    }

    public <R> RequestHandler2<T, R> param(Class<R> paramClass) {
        return new RequestHandler2<T, R>(this.method, this.path, this.resolver, ParameterResolver.path(1, paramClass), this.errorHandler, this.mediaTypeMapper);
    }

    public <R> RequestHandler2<T, R> body(Class<R> bodyClass) {
        return new RequestHandler2<T, R>(this.method, this.path, this.resolver, ParameterResolver.body(bodyClass, this.mediaTypeMapper), this.errorHandler, this.mediaTypeMapper);
    }

    @Deprecated
    public <R> RequestHandler2<T, R> body(Class<R> bodyClass, Class<? extends Mapper> mapperClass) {
        return this.body(bodyClass, this.mapperFrom(mapperClass));
    }

    @Deprecated
    public <R> RequestHandler2<T, R> body(Class<R> bodyClass, Mapper mapper) {
        return new RequestHandler2<T, R>(this.method, this.path, this.resolver, ParameterResolver.body(bodyClass, mapper), this.errorHandler, this.mediaTypeMapper);
    }

    public <R> RequestHandler2<T, R> body(Class<R> bodyClass, MediaTypeMapper mediaTypeMapper) {
        this.mediaTypeMapper = mediaTypeMapper;
        return new RequestHandler2<T, R>(this.method, this.path, this.resolver, ParameterResolver.body(bodyClass, mediaTypeMapper), this.errorHandler, mediaTypeMapper);
    }

    public RequestHandler2<T, String> query(String name) {
        return this.query(name, String.class);
    }

    public <R> RequestHandler2<T, R> query(String name, Class<R> queryClass) {
        return this.query(name, queryClass, null);
    }

    public <R> RequestHandler2<T, R> query(String name, Class<R> queryClass, R defaultValue) {
        return new RequestHandler2<T, R>(this.method, this.path, this.resolver, ParameterResolver.query(name, queryClass, defaultValue), this.errorHandler, this.mediaTypeMapper);
    }

    public RequestHandler2<T, Header> header(String name) {
        return new RequestHandler2<T, Header>(this.method, this.path, this.resolver, ParameterResolver.header(name), this.errorHandler, this.mediaTypeMapper);
    }

    @FunctionalInterface
    static interface ParamExecutor1<T> {
        public Completes<Response> execute(Request var1, T var2, MediaTypeMapper var3, ErrorHandler var4, Logger var5);
    }

    @FunctionalInterface
    public static interface ObjectHandler1<O, T> {
        public Completes<ObjectResponse<O>> execute(T var1);
    }

    @FunctionalInterface
    public static interface Handler1<T> {
        public Completes<Response> execute(T var1);
    }
}

