/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ParameterResolver;
import io.vlingo.http.resource.RequestExecutor;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestHandler3;
import io.vlingo.http.resource.RequestObjectExecutor;
import java.util.Arrays;
import java.util.function.Supplier;

public class RequestHandler2<T, R>
extends RequestHandler {
    final ParameterResolver<T> resolverParam1;
    final ParameterResolver<R> resolverParam2;
    private ParamExecutor2<T, R> executor;

    RequestHandler2(Method method, String path, ParameterResolver<T> resolverParam1, ParameterResolver<R> resolverParam2, ErrorHandler errorHandler, MediaTypeMapper mediaTypeMapper) {
        super(method, path, Arrays.asList(resolverParam1, resolverParam2), errorHandler, mediaTypeMapper);
        this.resolverParam1 = resolverParam1;
        this.resolverParam2 = resolverParam2;
    }

    Completes<Response> execute(Request request, T param1, R param2, Logger logger) {
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public RequestHandler2<T, R> handle(Handler2<T, R> handler) {
        this.executor = (request, param1, param2, mediaTypeMapper1, errorHandler1, logger1) -> RequestExecutor.executeRequest(() -> handler.execute(param1, param2), errorHandler1, logger1);
        return this;
    }

    public <O> RequestHandler2<T, R> handle(ObjectHandler2<O, T, R> handler) {
        this.executor = (request, param1, param2, mediaTypeMapper1, errorHandler1, logger) -> RequestObjectExecutor.executeRequest(request, mediaTypeMapper1, () -> handler.execute(param1, param2), errorHandler1, logger);
        return this;
    }

    public RequestHandler2<T, R> onError(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public Completes<Response> execute(Request request, Action.MappedParameters mappedParameters, Logger logger) {
        T param1 = this.resolverParam1.apply(request, mappedParameters);
        R param2 = this.resolverParam2.apply(request, mappedParameters);
        return this.execute(request, param1, param2, logger);
    }

    public <U> RequestHandler3<T, R, U> param(Class<U> paramClass) {
        return new RequestHandler3<T, R, U>(this.method, this.path, this.resolverParam1, this.resolverParam2, ParameterResolver.path(2, paramClass), this.errorHandler, this.mediaTypeMapper);
    }

    public <U> RequestHandler3<T, R, U> body(Class<U> bodyClass) {
        return new RequestHandler3<T, R, U>(this.method, this.path, this.resolverParam1, this.resolverParam2, ParameterResolver.body(bodyClass, this.mediaTypeMapper), this.errorHandler, this.mediaTypeMapper);
    }

    @Deprecated
    public <U> RequestHandler3<T, R, U> body(Class<U> bodyClass, Class<? extends Mapper> mapperClass) {
        return this.body(bodyClass, this.mapperFrom(mapperClass));
    }

    @Deprecated
    public <U> RequestHandler3<T, R, U> body(Class<U> bodyClass, Mapper mapper) {
        return new RequestHandler3<T, R, U>(this.method, this.path, this.resolverParam1, this.resolverParam2, ParameterResolver.body(bodyClass, mapper), this.errorHandler, this.mediaTypeMapper);
    }

    public <U> RequestHandler3<T, R, U> body(Class<U> bodyClass, MediaTypeMapper mediaTypeMapper) {
        this.mediaTypeMapper = mediaTypeMapper;
        return new RequestHandler3<T, R, U>(this.method, this.path, this.resolverParam1, this.resolverParam2, ParameterResolver.body(bodyClass, mediaTypeMapper), this.errorHandler, mediaTypeMapper);
    }

    public RequestHandler3<T, R, String> query(String name) {
        return this.query(name, String.class);
    }

    public <U> RequestHandler3<T, R, U> query(String name, Class<U> queryClass) {
        return new RequestHandler3<T, R, U>(this.method, this.path, this.resolverParam1, this.resolverParam2, ParameterResolver.query(name, queryClass), this.errorHandler, this.mediaTypeMapper);
    }

    public RequestHandler3<T, R, Header> header(String name) {
        return new RequestHandler3<T, R, Header>(this.method, this.path, this.resolverParam1, this.resolverParam2, ParameterResolver.header(name), this.errorHandler, this.mediaTypeMapper);
    }

    @FunctionalInterface
    static interface ParamExecutor2<T, R> {
        public Completes<Response> execute(Request var1, T var2, R var3, MediaTypeMapper var4, ErrorHandler var5, Logger var6);
    }

    @FunctionalInterface
    public static interface ObjectHandler2<O, T, R> {
        public Completes<ObjectResponse<O>> execute(T var1, R var2);
    }

    @FunctionalInterface
    public static interface Handler2<T, R> {
        public Completes<Response> execute(T var1, R var2);
    }
}

