/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ParameterResolver;
import io.vlingo.http.resource.RequestExecutor;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestHandler4;
import io.vlingo.http.resource.RequestObjectExecutor;
import java.util.Arrays;
import java.util.function.Supplier;

public class RequestHandler3<T, R, U>
extends RequestHandler {
    final ParameterResolver<T> resolverParam1;
    final ParameterResolver<R> resolverParam2;
    final ParameterResolver<U> resolverParam3;
    private ParamExecutor3<T, R, U> executor;

    RequestHandler3(Method method, String path, ParameterResolver<T> resolverParam1, ParameterResolver<R> resolverParam2, ParameterResolver<U> resolverParam3, ErrorHandler errorHandler, MediaTypeMapper mediaTypeMapper) {
        super(method, path, Arrays.asList(resolverParam1, resolverParam2, resolverParam3), errorHandler, mediaTypeMapper);
        this.resolverParam1 = resolverParam1;
        this.resolverParam2 = resolverParam2;
        this.resolverParam3 = resolverParam3;
    }

    Completes<Response> execute(Request request, T param1, R param2, U param3, Logger logger) {
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public RequestHandler3<T, R, U> handle(Handler3<T, R, U> handler) {
        this.executor = (request, param1, param2, param3, mediaTypeMapper1, errorHandler1, logger1) -> RequestExecutor.executeRequest(() -> handler.execute(param1, param2, param3), errorHandler1, logger1);
        return this;
    }

    public <O> RequestHandler3<T, R, U> handle(ObjectHandler3<O, T, R, U> handler) {
        this.executor = (request, param1, param2, param3, mediaTypeMapper1, errorHandler1, logger) -> RequestObjectExecutor.executeRequest(request, mediaTypeMapper1, () -> handler.execute(param1, param2, param3), errorHandler1, logger);
        return this;
    }

    public RequestHandler3<T, R, U> onError(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    protected Completes<Response> execute(Request request, Action.MappedParameters mappedParameters, Logger logger) {
        T param1 = this.resolverParam1.apply(request, mappedParameters);
        R param2 = this.resolverParam2.apply(request, mappedParameters);
        U param3 = this.resolverParam3.apply(request, mappedParameters);
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public <I> RequestHandler4<T, R, U, I> param(Class<I> paramClass) {
        return new RequestHandler4<T, R, U, I>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, ParameterResolver.path(3, paramClass), this.errorHandler, this.mediaTypeMapper);
    }

    public <I> RequestHandler4<T, R, U, I> body(Class<I> bodyClass) {
        return new RequestHandler4<T, R, U, I>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, ParameterResolver.body(bodyClass, this.mediaTypeMapper), this.errorHandler, this.mediaTypeMapper);
    }

    @Deprecated
    public <I> RequestHandler4<T, R, U, I> body(Class<I> bodyClass, Class<? extends Mapper> mapperClass) {
        return this.body(bodyClass, this.mapperFrom(mapperClass));
    }

    @Deprecated
    public <I> RequestHandler4<T, R, U, I> body(Class<I> bodyClass, Mapper mapper) {
        return new RequestHandler4<T, R, U, I>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, ParameterResolver.body(bodyClass, mapper), this.errorHandler, this.mediaTypeMapper);
    }

    public <I> RequestHandler4<T, R, U, I> body(Class<I> bodyClass, MediaTypeMapper mediaTypeMapper) {
        this.mediaTypeMapper = mediaTypeMapper;
        return new RequestHandler4<T, R, U, I>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, ParameterResolver.body(bodyClass, mediaTypeMapper), this.errorHandler, mediaTypeMapper);
    }

    public RequestHandler4<T, R, U, String> query(String name) {
        return this.query(name, String.class);
    }

    public <I> RequestHandler4<T, R, U, I> query(String name, Class<I> queryClass) {
        return new RequestHandler4<T, R, U, I>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, ParameterResolver.query(name, queryClass), this.errorHandler, this.mediaTypeMapper);
    }

    public RequestHandler4<T, R, U, Header> header(String name) {
        return new RequestHandler4<T, R, U, Header>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, ParameterResolver.header(name), this.errorHandler, this.mediaTypeMapper);
    }

    @FunctionalInterface
    static interface ParamExecutor3<T, R, U> {
        public Completes<Response> execute(Request var1, T var2, R var3, U var4, MediaTypeMapper var5, ErrorHandler var6, Logger var7);
    }

    @FunctionalInterface
    public static interface ObjectHandler3<O, T, R, U> {
        public Completes<ObjectResponse<O>> execute(T var1, R var2, U var3);
    }

    @FunctionalInterface
    public static interface Handler3<T, R, U> {
        public Completes<Response> execute(T var1, R var2, U var3);
    }
}

