/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ParameterResolver;
import io.vlingo.http.resource.RequestExecutor;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestHandler5;
import io.vlingo.http.resource.RequestObjectExecutor;
import java.util.Arrays;
import java.util.function.Supplier;

public class RequestHandler4<T, R, U, I>
extends RequestHandler {
    final ParameterResolver<T> resolverParam1;
    final ParameterResolver<R> resolverParam2;
    final ParameterResolver<U> resolverParam3;
    final ParameterResolver<I> resolverParam4;
    private ParamExecutor4<T, R, U, I> executor;

    RequestHandler4(Method method, String path, ParameterResolver<T> resolverParam1, ParameterResolver<R> resolverParam2, ParameterResolver<U> resolverParam3, ParameterResolver<I> resolverParam4, ErrorHandler errorHandler, MediaTypeMapper mediaTypeMapper) {
        super(method, path, Arrays.asList(resolverParam1, resolverParam2, resolverParam3, resolverParam4), errorHandler, mediaTypeMapper);
        this.resolverParam1 = resolverParam1;
        this.resolverParam2 = resolverParam2;
        this.resolverParam3 = resolverParam3;
        this.resolverParam4 = resolverParam4;
    }

    Completes<Response> execute(Request request, T param1, R param2, U param3, I param4, Logger logger) {
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, param4, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public RequestHandler4<T, R, U, I> handle(Handler4<T, R, U, I> handler) {
        this.executor = (request, param1, param2, param3, param4, mediaTypeMapper1, errorHandler1, logger1) -> RequestExecutor.executeRequest(() -> handler.execute(param1, param2, param3, param4), errorHandler1, logger1);
        return this;
    }

    public <O> RequestHandler4<T, R, U, I> handle(ObjectHandler4<O, T, R, U, I> handler) {
        this.executor = (request, param1, param2, param3, param4, mediaTypeMapper1, errorHandler1, logger) -> RequestObjectExecutor.executeRequest(request, mediaTypeMapper1, () -> handler.execute(param1, param2, param3, param4), errorHandler1, logger);
        return this;
    }

    public RequestHandler4<T, R, U, I> onError(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    protected Completes<Response> execute(Request request, Action.MappedParameters mappedParameters, Logger logger) {
        T param1 = this.resolverParam1.apply(request, mappedParameters);
        R param2 = this.resolverParam2.apply(request, mappedParameters);
        U param3 = this.resolverParam3.apply(request, mappedParameters);
        I param4 = this.resolverParam4.apply(request, mappedParameters);
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, param4, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public <J> RequestHandler5<T, R, U, I, J> param(Class<J> paramClass) {
        return new RequestHandler5<T, R, U, I, J>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, ParameterResolver.path(4, paramClass), this.errorHandler, this.mediaTypeMapper);
    }

    public <J> RequestHandler5<T, R, U, I, J> body(Class<J> bodyClass) {
        return new RequestHandler5<T, R, U, I, J>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, ParameterResolver.body(bodyClass, this.mediaTypeMapper), this.errorHandler, this.mediaTypeMapper);
    }

    @Deprecated
    public <J> RequestHandler5<T, R, U, I, J> body(Class<J> bodyClass, Class<? extends Mapper> mapperClass) {
        return this.body(bodyClass, this.mapperFrom(mapperClass));
    }

    @Deprecated
    public <J> RequestHandler5<T, R, U, I, J> body(Class<J> bodyClass, Mapper mapper) {
        return new RequestHandler5<T, R, U, I, J>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, ParameterResolver.body(bodyClass, mapper), this.errorHandler, this.mediaTypeMapper);
    }

    public <J> RequestHandler5<T, R, U, I, J> body(Class<J> bodyClass, MediaTypeMapper mediaTypeMapper) {
        return new RequestHandler5<T, R, U, I, J>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, ParameterResolver.body(bodyClass, mediaTypeMapper), this.errorHandler, mediaTypeMapper);
    }

    public RequestHandler5<T, R, U, I, String> query(String name) {
        return this.query(name, String.class);
    }

    public <J> RequestHandler5<T, R, U, I, J> query(String name, Class<J> queryClass) {
        return new RequestHandler5<T, R, U, I, J>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, ParameterResolver.query(name, queryClass), this.errorHandler, this.mediaTypeMapper);
    }

    public RequestHandler5<T, R, U, I, Header> header(String name) {
        return new RequestHandler5<T, R, U, I, Header>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, ParameterResolver.header(name), this.errorHandler, this.mediaTypeMapper);
    }

    static interface ParamExecutor4<T, R, U, I> {
        public Completes<Response> execute(Request var1, T var2, R var3, U var4, I var5, MediaTypeMapper var6, ErrorHandler var7, Logger var8);
    }

    @FunctionalInterface
    public static interface ObjectHandler4<O, T, R, U, I> {
        public Completes<ObjectResponse<O>> execute(T var1, R var2, U var3, I var4);
    }

    @FunctionalInterface
    public static interface Handler4<T, R, U, I> {
        public Completes<Response> execute(T var1, R var2, U var3, I var4);
    }
}

