/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ParameterResolver;
import io.vlingo.http.resource.RequestExecutor;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestHandler6;
import io.vlingo.http.resource.RequestObjectExecutor;
import java.util.Arrays;
import java.util.function.Supplier;

public class RequestHandler5<T, R, U, I, J>
extends RequestHandler {
    final ParameterResolver<T> resolverParam1;
    final ParameterResolver<R> resolverParam2;
    final ParameterResolver<U> resolverParam3;
    final ParameterResolver<I> resolverParam4;
    final ParameterResolver<J> resolverParam5;
    private ParamExecutor5<T, R, U, I, J> executor;

    RequestHandler5(Method method, String path, ParameterResolver<T> resolverParam1, ParameterResolver<R> resolverParam2, ParameterResolver<U> resolverParam3, ParameterResolver<I> resolverParam4, ParameterResolver<J> resolverParam5, ErrorHandler errorHandler, MediaTypeMapper mediaTypeMapper) {
        super(method, path, Arrays.asList(resolverParam1, resolverParam2, resolverParam3, resolverParam4, resolverParam5), errorHandler, mediaTypeMapper);
        this.resolverParam1 = resolverParam1;
        this.resolverParam2 = resolverParam2;
        this.resolverParam3 = resolverParam3;
        this.resolverParam4 = resolverParam4;
        this.resolverParam5 = resolverParam5;
    }

    Completes<Response> execute(Request request, T param1, R param2, U param3, I param4, J param5, Logger logger) {
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, param4, param5, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public RequestHandler5<T, R, U, I, J> handle(Handler5<T, R, U, I, J> handler) {
        this.executor = (request, param1, param2, param3, param4, param5, mediaTypeMapper1, errorHandler1, logger1) -> RequestExecutor.executeRequest(() -> handler.execute(param1, param2, param3, param4, param5), errorHandler1, logger1);
        return this;
    }

    public <O> RequestHandler5<T, R, U, I, J> handle(ObjectHandler5<O, T, R, U, I, J> handler) {
        this.executor = (request, param1, param2, param3, param4, param5, mediaTypeMapper1, errorHandler1, logger) -> RequestObjectExecutor.executeRequest(request, mediaTypeMapper1, () -> handler.execute(param1, param2, param3, param4, param5), errorHandler1, logger);
        return this;
    }

    public RequestHandler5<T, R, U, I, J> onError(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    protected Completes<Response> execute(Request request, Action.MappedParameters mappedParameters, Logger logger) {
        T param1 = this.resolverParam1.apply(request, mappedParameters);
        R param2 = this.resolverParam2.apply(request, mappedParameters);
        U param3 = this.resolverParam3.apply(request, mappedParameters);
        I param4 = this.resolverParam4.apply(request, mappedParameters);
        J param5 = this.resolverParam5.apply(request, mappedParameters);
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, param4, param5, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public <K> RequestHandler6<T, R, U, I, J, K> param(Class<K> paramClass) {
        return new RequestHandler6<T, R, U, I, J, K>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, this.resolverParam5, ParameterResolver.path(5, paramClass), this.errorHandler, this.mediaTypeMapper);
    }

    public <K> RequestHandler6<T, R, U, I, J, K> body(Class<K> bodyClass) {
        return new RequestHandler6<T, R, U, I, J, K>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, this.resolverParam5, ParameterResolver.body(bodyClass, this.mediaTypeMapper), this.errorHandler, this.mediaTypeMapper);
    }

    public RequestHandler6<T, R, U, I, J, String> query(String name) {
        return this.query(name, String.class);
    }

    public <K> RequestHandler6<T, R, U, I, J, K> query(String name, Class<K> queryClass) {
        return new RequestHandler6<T, R, U, I, J, K>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, this.resolverParam5, ParameterResolver.query(name, queryClass), this.errorHandler, this.mediaTypeMapper);
    }

    public RequestHandler6<T, R, U, I, J, Header> header(String name) {
        return new RequestHandler6<T, R, U, I, J, Header>(this.method, this.path, this.resolverParam1, this.resolverParam2, this.resolverParam3, this.resolverParam4, this.resolverParam5, ParameterResolver.header(name), this.errorHandler, this.mediaTypeMapper);
    }

    @FunctionalInterface
    static interface ParamExecutor5<T, R, U, I, J> {
        public Completes<Response> execute(Request var1, T var2, R var3, U var4, I var5, J var6, MediaTypeMapper var7, ErrorHandler var8, Logger var9);
    }

    @FunctionalInterface
    public static interface ObjectHandler5<O, T, R, U, I, J> {
        public Completes<ObjectResponse<O>> execute(T var1, R var2, U var3, I var4, J var5);
    }

    @FunctionalInterface
    public static interface Handler5<T, R, U, I, J> {
        public Completes<Response> execute(T var1, R var2, U var3, I var4, J var5);
    }
}

