/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ParameterResolver;
import io.vlingo.http.resource.RequestExecutor;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestObjectExecutor;
import java.util.Arrays;
import java.util.function.Supplier;

public class RequestHandler6<T, R, U, I, J, K>
extends RequestHandler {
    final ParameterResolver<T> resolverParam1;
    final ParameterResolver<R> resolverParam2;
    final ParameterResolver<U> resolverParam3;
    final ParameterResolver<I> resolverParam4;
    final ParameterResolver<J> resolverParam5;
    final ParameterResolver<K> resolverParam6;
    private ParamExecutor6<T, R, U, I, J, K> executor;

    RequestHandler6(Method method, String path, ParameterResolver<T> resolverParam1, ParameterResolver<R> resolverParam2, ParameterResolver<U> resolverParam3, ParameterResolver<I> resolverParam4, ParameterResolver<J> resolverParam5, ParameterResolver<K> resolverParam6, ErrorHandler errorHandler, MediaTypeMapper mediaTypeMapper) {
        super(method, path, Arrays.asList(resolverParam1, resolverParam2, resolverParam3, resolverParam4, resolverParam5, resolverParam6), errorHandler, mediaTypeMapper);
        this.resolverParam1 = resolverParam1;
        this.resolverParam2 = resolverParam2;
        this.resolverParam3 = resolverParam3;
        this.resolverParam4 = resolverParam4;
        this.resolverParam5 = resolverParam5;
        this.resolverParam6 = resolverParam6;
    }

    Completes<Response> execute(Request request, T param1, R param2, U param3, I param4, J param5, K param6, Logger logger) {
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, param4, param5, param6, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    public RequestHandler6<T, R, U, I, J, K> handle(Handler6<T, R, U, I, J, K> handler) {
        this.executor = (request, param1, param2, param3, param4, param5, param6, mediaTypeMapper1, errorHandler1, logger1) -> RequestExecutor.executeRequest(() -> handler.execute(param1, param2, param3, param4, param5, param6), errorHandler1, logger1);
        return this;
    }

    public <O> RequestHandler6<T, R, U, I, J, K> handle(ObjectHandler6<O, T, R, U, I, J, K> handler) {
        this.executor = (request, param1, param2, param3, param4, param5, param6, mediaTypeMapper1, errorHandler1, logger) -> RequestObjectExecutor.executeRequest(request, mediaTypeMapper1, () -> handler.execute(param1, param2, param3, param4, param5, param6), errorHandler1, logger);
        return this;
    }

    public RequestHandler6<T, R, U, I, J, K> onError(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    protected Completes<Response> execute(Request request, Action.MappedParameters mappedParameters, Logger logger) {
        T param1 = this.resolverParam1.apply(request, mappedParameters);
        R param2 = this.resolverParam2.apply(request, mappedParameters);
        U param3 = this.resolverParam3.apply(request, mappedParameters);
        I param4 = this.resolverParam4.apply(request, mappedParameters);
        J param5 = this.resolverParam5.apply(request, mappedParameters);
        K param6 = this.resolverParam6.apply(request, mappedParameters);
        Supplier<Completes> exec = () -> this.executor.execute(request, param1, param2, param3, param4, param5, param6, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    @FunctionalInterface
    static interface ParamExecutor6<T, R, U, I, J, K> {
        public Completes<Response> execute(Request var1, T var2, R var3, U var4, I var5, J var6, K var7, MediaTypeMapper var8, ErrorHandler var9, Logger var10);
    }

    @FunctionalInterface
    public static interface ObjectHandler6<O, T, R, U, I, J, K> {
        public Completes<ObjectResponse<O>> execute(T var1, R var2, U var3, I var4, J var5, K var6);
    }

    @FunctionalInterface
    public static interface Handler6<T, R, U, I, J, K> {
        public Completes<Response> execute(T var1, R var2, U var3, I var4, J var5, K var6);
    }
}

