/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.common.Success;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ResourceErrorProcessor;
import java.util.function.Supplier;

abstract class RequestObjectExecutor {
    RequestObjectExecutor() {
    }

    static <O> Completes<Response> executeRequest(Request request, MediaTypeMapper mediaTypeMapper, Supplier<Completes<ObjectResponse<O>>> executeAction, ErrorHandler errorHandler, Logger logger) {
        try {
            return executeAction.get().andFinally(objectResponse -> RequestObjectExecutor.toResponse(objectResponse, request, mediaTypeMapper, errorHandler, logger));
        }
        catch (Exception ex) {
            return Completes.withFailure((Object)ResourceErrorProcessor.resourceHandlerError(errorHandler, logger, ex));
        }
    }

    static <O> Response toResponse(ObjectResponse<O> objectResponse, Request request, MediaTypeMapper mediaTypeMapper, ErrorHandler errorHandler, Logger logger) {
        return (Response)Success.of((Object)objectResponse.responseFrom(request, mediaTypeMapper)).resolve(ex -> ResourceErrorProcessor.resourceHandlerError(errorHandler, logger, (Exception)ex), response -> response);
    }
}

