/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Actor;
import io.vlingo.common.Cancellable;
import io.vlingo.common.Scheduled;
import io.vlingo.http.Request;
import io.vlingo.http.resource.Client;
import io.vlingo.http.resource.ClientConsumerCommons;
import io.vlingo.http.resource.RequestSender;
import io.vlingo.wire.channel.ResponseChannelConsumer;
import io.vlingo.wire.fdx.bidirectional.ClientRequestResponseChannel;
import io.vlingo.wire.message.ByteBufferAllocator;
import io.vlingo.wire.message.Converters;
import java.nio.ByteBuffer;

public class RequestSenderProbeActor
extends Actor
implements RequestSender,
Scheduled<Object> {
    private final ByteBuffer buffer;
    private final ClientRequestResponseChannel channel;
    private final Cancellable cancellable;

    public RequestSenderProbeActor(Client.Configuration configuration, ResponseChannelConsumer consumer, String testId) throws Exception {
        this.channel = ClientConsumerCommons.clientChannel(configuration, consumer, this.logger());
        this.cancellable = this.stage().scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, 1L, configuration.probeInterval);
        this.buffer = ByteBufferAllocator.allocate((int)configuration.writeBufferSize);
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.channel.probeChannel();
    }

    @Override
    public void sendRequest(Request request) {
        this.buffer.clear();
        this.buffer.put(Converters.textToBytes((String)request.toString()));
        this.buffer.flip();
        this.channel.requestWith(this.buffer);
    }

    public void stop() {
        this.cancellable.cancel();
        this.channel.close();
        super.stop();
    }
}

