/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Definition;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.http.Context;
import io.vlingo.http.Method;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ResourceHandler;
import io.vlingo.http.resource.ResourceRequestHandler;
import io.vlingo.http.resource.ResourceRequestHandlerActor;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Resource<T> {
    public final String name;
    public final int handlerPoolSize;
    private final ResourceRequestHandler[] handlerPool;
    private final AtomicLong handlerPoolIndex;

    public abstract void dispatchToHandlerWith(Context var1, Action.MappedParameters var2);

    abstract Action.MatchResults matchWith(Method var1, URI var2);

    protected abstract void log(Logger var1);

    protected abstract ResourceHandler resourceHandlerInstance(Stage var1);

    void allocateHandlerPool(Stage stage) {
        for (int idx = 0; idx < this.handlerPoolSize; ++idx) {
            this.handlerPool[idx] = (ResourceRequestHandler)stage.actorFor(ResourceRequestHandler.class, Definition.has(ResourceRequestHandlerActor.class, (List)Definition.parameters((Object[])new Object[]{this.resourceHandlerInstance(stage)})));
        }
    }

    protected ResourceRequestHandler pooledHandler() {
        int index = (int)(this.handlerPoolIndex.incrementAndGet() % (long)this.handlerPoolSize);
        return this.handlerPool[index];
    }

    Resource(String name, int handlerPoolSize) {
        this.name = name;
        this.handlerPoolSize = handlerPoolSize;
        this.handlerPool = new ResourceRequestHandler[handlerPoolSize];
        this.handlerPoolIndex = new AtomicLong(0L);
    }
}

