/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.http.Method;
import io.vlingo.http.resource.DynamicResource;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestHandler0;
import io.vlingo.http.resource.Resource;
import java.util.Arrays;

public interface ResourceBuilder {
    public static Resource<?> resource(String name, RequestHandler ... requestHandlers) {
        return ResourceBuilder.resource(name, 10, requestHandlers);
    }

    public static Resource<?> resource(String name, int handlerPoolSize, RequestHandler ... requestHandlers) {
        return new DynamicResource(name, handlerPoolSize, Arrays.asList(requestHandlers));
    }

    public static RequestHandler0 get(String uri) {
        return new RequestHandler0(Method.GET, uri);
    }

    public static RequestHandler0 post(String uri) {
        return new RequestHandler0(Method.POST, uri);
    }

    public static RequestHandler0 put(String uri) {
        return new RequestHandler0(Method.PUT, uri);
    }

    public static RequestHandler0 delete(String uri) {
        return new RequestHandler0(Method.DELETE, uri);
    }

    public static RequestHandler0 patch(String uri) {
        return new RequestHandler0(Method.PATCH, uri);
    }

    public static RequestHandler0 head(String uri) {
        return new RequestHandler0(Method.HEAD, uri);
    }

    public static RequestHandler0 options(String uri) {
        return new RequestHandler0(Method.OPTIONS, uri);
    }

    public static RequestHandler0 trace(String uri) {
        return new RequestHandler0(Method.TRACE, uri);
    }

    public static RequestHandler0 connect(String uri) {
        return new RequestHandler0(Method.CONNECT, uri);
    }
}

