/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.common.compiler.DynaFile;
import io.vlingo.common.compiler.DynaNaming;
import io.vlingo.common.compiler.DynaType;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.Properties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.List;

public class ResourceDispatcherGenerator
implements AutoCloseable {
    private final List<Action> actions;
    private final boolean persist;
    private final String rootOfClasses;
    private final String rootOfGenerated;
    private final File targetClassesPath;
    private final DynaType type;
    private final URLClassLoader urlClassLoader;

    static ResourceDispatcherGenerator forMain(List<Action> actions, boolean persist) throws Exception {
        String root = Properties.properties.getProperty("resource.dispatcher.generated.classes.main", "target/classes/");
        return new ResourceDispatcherGenerator(actions, root, DynaType.Main, persist);
    }

    static ResourceDispatcherGenerator forTest(List<Action> actions, boolean persist) throws Exception {
        String root = Properties.properties.getProperty("resource.dispatcher.generated.classes.test", "target/test-classes/");
        return new ResourceDispatcherGenerator(actions, root, DynaType.Test, persist);
    }

    @Override
    public void close() throws Exception {
        this.urlClassLoader.close();
    }

    Result generateFor(String handlerProtocol) {
        System.out.println("vlingo/http: Generating handler dispatcher for " + (this.type == DynaType.Main ? "main" : "test") + ": " + handlerProtocol);
        String relativePathToClass = DynaFile.toFullPath((String)handlerProtocol);
        String relativePathToClassFile = this.rootOfClasses + relativePathToClass + ".class";
        File targetClassesRelativePathToClass = new File(relativePathToClassFile);
        if (targetClassesRelativePathToClass.exists()) {
            try {
                Class<?> handlerInterface = this.readHandlerInterface(handlerProtocol);
                String dispatcherClassSource = this.dispatcherClassSource(handlerInterface);
                String fullyQualifiedClassname = DynaNaming.fullyQualifiedClassnameFor(handlerInterface, (String)"Dispatcher");
                String relativeTargetFile = DynaFile.toFullPath((String)fullyQualifiedClassname);
                File sourceFile = this.persist ? this.persistDispatcherClassSource(handlerProtocol, relativeTargetFile, dispatcherClassSource) : new File(relativeTargetFile);
                return new Result(fullyQualifiedClassname, DynaNaming.classnameFor(handlerInterface, (String)"Dispatcher"), dispatcherClassSource, sourceFile);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot generate resource dispatcher class for: " + handlerProtocol, e);
            }
        }
        throw new IllegalArgumentException("Cannot generate resource dispatcher class for " + handlerProtocol + " because there is no corresponding:\n" + relativePathToClassFile);
    }

    DynaType type() {
        return this.type;
    }

    URLClassLoader urlClassLoader() {
        return this.urlClassLoader;
    }

    private ResourceDispatcherGenerator(List<Action> actions, String rootOfClasses, DynaType type, boolean persist) throws Exception {
        this.actions = actions;
        this.rootOfClasses = rootOfClasses;
        this.rootOfGenerated = this.rootOfGeneratedSources(type);
        this.type = type;
        this.persist = persist;
        this.targetClassesPath = new File(rootOfClasses);
        this.urlClassLoader = this.initializeClassLoader(this.targetClassesPath);
    }

    private String actionCase(Action action) {
        StringBuilder builder = new StringBuilder();
        builder.append("      case ").append(action.id).append(": // ").append(action.method.toString()).append(" ").append(action.uri).append(" ").append(action.originalTo).append("\n");
        builder.append("        consumer = (handler) -> handler.").append(this.asExpression(action.to)).append(";\n");
        builder.append("        pooledHandler().handleFor(context, consumer);\n");
        builder.append("        break;\n");
        return builder.toString();
    }

    public String asExpression(Action.ToSpec to) {
        StringBuilder builder = new StringBuilder();
        builder.append(to.methodName()).append("(");
        String separator = "";
        int parameterIndex = 0;
        for (Action.MethodParameter parameter : to.parameters()) {
            builder.append(separator).append("(").append(parameter.type).append(") ").append("mappedParameters.mapped.get(" + parameterIndex + ").value");
            ++parameterIndex;
            separator = ", ";
        }
        builder.append(")");
        return builder.toString();
    }

    private String classStatement(Class<?> handlerInterface) {
        return MessageFormat.format("public class {0} extends ConfigurationResource<{1}> '{'\n", DynaNaming.classnameFor(handlerInterface, (String)"Dispatcher"), handlerInterface.getSimpleName());
    }

    private String constructor(Class<?> protocolInterface) {
        StringBuilder builder = new StringBuilder();
        String signature0 = MessageFormat.format("  public {0}(\n", DynaNaming.classnameFor(protocolInterface, (String)"Dispatcher"));
        String signature1 = "          final String name,\n";
        String signature2 = "          final Class<? extends ResourceHandler> resourceHandlerClass,\n";
        String signature3 = "          final int handlerPoolSize,\n";
        String signature4 = "          final List<Action> actions) {\n";
        builder.append(signature0).append("          final String name,\n").append("          final Class<? extends ResourceHandler> resourceHandlerClass,\n").append("          final int handlerPoolSize,\n").append("          final List<Action> actions) {\n").append("    super(name, resourceHandlerClass, handlerPoolSize, actions);\n").append("  }\n");
        return builder.toString();
    }

    private String dispatcherClassSource(Class<?> handlerType) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.packageStatement(handlerType)).append("\n\n").append(this.importStatements(handlerType)).append("\n").append(this.classStatement(handlerType)).append("\n").append(this.constructor(handlerType)).append("\n").append(this.methodDefinition(handlerType)).append("}").append("\n");
        return builder.toString();
    }

    private String importStatements(Class<?> handlerInterface) {
        StringBuilder builder = new StringBuilder();
        builder.append("import java.util.List;").append("\n").append("import java.util.function.Consumer;").append("\n\n").append("import io.vlingo.http.Context;").append("\n").append("import io.vlingo.http.resource.Action;").append("\n").append("import io.vlingo.http.resource.Action.MappedParameters;").append("\n").append("import io.vlingo.http.resource.ConfigurationResource;").append("\n").append("import io.vlingo.http.resource.ResourceHandler;").append("\n");
        Class<?> outerClass = handlerInterface.getDeclaringClass();
        if (outerClass != null) {
            builder.append("import " + outerClass.getName() + "." + handlerInterface.getSimpleName() + ";").append("\n");
        }
        return builder.toString();
    }

    private URLClassLoader initializeClassLoader(File targetClassesPath) throws MalformedURLException {
        String classpath = "file://" + targetClassesPath.getAbsolutePath() + "/";
        URL url = new URL(classpath);
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url});
        return urlClassLoader;
    }

    private String methodDefinition(Class<?> handlerType) {
        StringBuilder builder = new StringBuilder();
        builder.append("  @Override\n").append("  public void dispatchToHandlerWith(final Context context, final MappedParameters mappedParameters) {\n").append("    Consumer<" + handlerType.getSimpleName() + "> consumer = null;\n").append("\n").append("    try {\n").append("      switch (mappedParameters.actionId) {\n");
        for (Action action : this.actions) {
            builder.append(this.actionCase(action));
        }
        builder.append("      }\n").append("    } catch (Exception e) {\n").append("      throw new IllegalArgumentException(\"Action mismatch: Request: \" + context.request + \"Parameters: \" + mappedParameters);\n").append("    }\n").append("  }\n");
        return builder.toString();
    }

    private String packageStatement(Class<?> handlerInterface) {
        return MessageFormat.format("package {0};", handlerInterface.getPackage().getName());
    }

    private File persistDispatcherClassSource(String handlerProtocol, String relativePathToClass, String dispatcherClassSource) throws Exception {
        String pathToGeneratedSource = DynaFile.toPackagePath((String)handlerProtocol);
        new File(this.rootOfGenerated + pathToGeneratedSource).mkdirs();
        String pathToSource = this.rootOfGenerated + relativePathToClass + ".java";
        return DynaFile.persistDynaClassSource((String)pathToSource, (String)dispatcherClassSource);
    }

    private Class<?> readHandlerInterface(String handlerProtocol) throws Exception {
        Class<?> handlerInterface = this.urlClassLoader.loadClass(handlerProtocol);
        return handlerInterface;
    }

    private String rootOfGeneratedSources(DynaType type) {
        String root = type == DynaType.Main ? Properties.properties.getProperty("resource.dispatcher.generated.sources.main", "target/generated-sources/") : Properties.properties.getProperty("resource.dispatcher.generated.sources.test", "target/generated-test-sources/");
        return root;
    }

    public static class Result {
        public final String classname;
        public final String fullyQualifiedClassname;
        public final String source;
        public final File sourceFile;

        private Result(String fullyQualifiedClassname, String classname, String source, File sourceFile) {
            this.fullyQualifiedClassname = fullyQualifiedClassname;
            this.classname = classname;
            this.source = source;
            this.sourceFile = sourceFile;
        }
    }
}

