/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.http.Response;
import io.vlingo.http.resource.DefaultErrorHandler;
import io.vlingo.http.resource.ErrorHandler;

public class ResourceErrorProcessor {
    static Response defaultErrorResponse() {
        return Response.of(Response.Status.InternalServerError);
    }

    static Response resourceHandlerError(ErrorHandler errorHandler, Logger logger, Exception exception) {
        Response response;
        try {
            logger.error("Exception thrown by Resource execution", (Throwable)exception);
            response = errorHandler != null ? errorHandler.handle(exception) : DefaultErrorHandler.instance().handle(exception);
        }
        catch (Exception errorHandlerException) {
            logger.error("Exception thrown by error handler when handling error", (Throwable)exception);
            response = ResourceErrorProcessor.defaultErrorResponse();
        }
        return response;
    }
}

