/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Actor;
import io.vlingo.http.Context;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.ResourceHandler;
import io.vlingo.http.resource.ResourceRequestHandler;
import java.util.function.Consumer;

public class ResourceRequestHandlerActor
extends Actor
implements ResourceRequestHandler {
    private final ResourceHandler resourceHandler;

    public ResourceRequestHandlerActor(ResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    @Override
    public void handleFor(Context context, Consumer consumer) {
        try {
            this.resourceHandler.context = context;
            this.resourceHandler.stage = this.stage();
            consumer.accept(this.resourceHandler);
        }
        catch (Error throwable) {
            this.logger().error("Error thrown by resource dispatcher", (Throwable)throwable);
            context.completes.with((Object)Response.of(Response.Status.InternalServerError));
        }
        catch (RuntimeException exception) {
            this.logger().error("Runtime thrown by resource dispatcher", (Throwable)exception);
            context.completes.with((Object)Response.of(Response.Status.InternalServerError));
        }
    }

    @Override
    public void handleFor(Context context, Action.MappedParameters mappedParameters, RequestHandler handler) {
        Consumer<ResourceHandler> consumer = resource -> handler.execute(context.request, mappedParameters, resource.logger()).andThen(outcome -> this.respondWith(context, (Response)outcome)).otherwise(failure -> this.respondWith(context, (Response)failure)).recoverFrom(exception -> Response.of(Response.Status.BadRequest, exception.getMessage())).andFinally();
        this.handleFor(context, consumer);
    }

    private Response respondWith(Context context, Response response) {
        context.completes.with((Object)response);
        return response;
    }
}

