/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.http.Context;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Resources {
    final Map<String, Resource<?>> namedResources;

    public static Resources are(Resource<?> ... resources) {
        Resources all = new Resources();
        for (Resource<?> resource : resources) {
            all.namedResources.put(resource.name, resource);
        }
        return all;
    }

    public String toString() {
        return "Resources[namedResources=" + this.namedResources + "]";
    }

    Resources(Map<String, Resource<?>> namedResources) {
        this.namedResources = Collections.unmodifiableMap(namedResources);
    }

    Resources(Resource<?> resource) {
        this.namedResources = new HashMap();
        this.namedResources.put(resource.name, resource);
    }

    private Resources() {
        this.namedResources = new HashMap();
    }

    Resource<?> resourceOf(String name) {
        return this.namedResources.get(name);
    }

    void dispatchMatching(Context context, Logger logger) {
        String message;
        try {
            for (Resource<?> resource : this.namedResources.values()) {
                Action.MatchResults matchResults = resource.matchWith(context.request.method, context.request.uri);
                if (!matchResults.isMatched()) continue;
                Action.MappedParameters mappedParameters = matchResults.action.map(context.request, matchResults.parameters());
                resource.dispatchToHandlerWith(context, mappedParameters);
                return;
            }
            message = "No matching resource for method " + (Object)((Object)context.request.method) + " and URI " + context.request.uri;
            logger.warn(message);
        }
        catch (Exception e) {
            message = "Problem dispatching request for method " + (Object)((Object)context.request.method) + " and URI " + context.request.uri + " because: " + e.getMessage();
            logger.error(message, (Throwable)e);
        }
        context.completes.with((Object)Response.of(Response.Status.NotFound, message));
    }
}

