/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Stoppable;
import io.vlingo.common.Completes;
import io.vlingo.http.Filters;
import io.vlingo.http.resource.Configuration;
import io.vlingo.http.resource.Loader;
import io.vlingo.http.resource.Properties;
import io.vlingo.http.resource.Resources;
import io.vlingo.http.resource.ServerActor;
import io.vlingo.wire.channel.RefreshableSelector;

public interface Server
extends Stoppable {
    public static Server startWith(Stage stage) {
        return Server.startWith(stage, Properties.properties);
    }

    public static Server startWith(Stage stage, java.util.Properties properties) {
        Configuration configuration = Configuration.defineWith(properties);
        Resources resources = Loader.loadResources(properties);
        return Server.startWith(stage, resources, configuration.port(), configuration.sizing(), configuration.timing());
    }

    public static Server startWith(Stage stage, Resources resources, int port, Configuration.Sizing sizing, Configuration.Timing timing) {
        return Server.startWith(stage, resources, Filters.none(), port, sizing, timing);
    }

    public static Server startWith(Stage stage, Resources resources, Filters filters, int port, Configuration.Sizing sizing, Configuration.Timing timing) {
        return Server.startWith(stage, resources, filters, port, sizing, timing, "queueMailbox", "queueMailbox");
    }

    public static Server startWith(Stage stage, Resources resources, Filters filters, int port, Configuration.Sizing sizing, Configuration.Timing timing, String severMailboxTypeName, String channelMailboxTypeName) {
        RefreshableSelector.withNoThreshold((Logger)stage.world().defaultLogger());
        Server server = (Server)stage.actorFor(Server.class, Definition.has(ServerActor.class, (ActorInstantiator)new ServerInstantiator(resources, filters, port, sizing, timing, channelMailboxTypeName), (String)severMailboxTypeName, (String)"vlingo-http-server"), stage.world().addressFactory().withHighId(), stage.world().defaultLogger());
        server.startUp();
        return server;
    }

    public static Server startWithAgent(Stage stage, Resources resources, int port, int dispatcherPoolSize) {
        return Server.startWithAgent(stage, resources, Filters.none(), port, dispatcherPoolSize);
    }

    public static Server startWithAgent(Stage stage, Resources resources, Filters filters, int port, int dispatcherPoolSize) {
        return Server.startWithAgent(stage, resources, filters, port, dispatcherPoolSize, "queueMailbox");
    }

    public static Server startWithAgent(Stage stage, Resources resources, Filters filters, int port, int dispatcherPoolSize, String severMailboxTypeName) {
        Server server = (Server)stage.actorFor(Server.class, Definition.has(ServerActor.class, (ActorInstantiator)new ServerWithAgentInstantiator(resources, filters, port, dispatcherPoolSize), (String)severMailboxTypeName, (String)"vlingo-http-server"), stage.world().addressFactory().withHighId(), stage.world().defaultLogger());
        server.startUp();
        return server;
    }

    public Completes<Boolean> shutDown();

    public Completes<Boolean> startUp();

    public static class ServerWithAgentInstantiator
    implements ActorInstantiator<ServerActor> {
        private static final long serialVersionUID = 9035408940262040413L;
        private final Resources resources;
        private final Filters filters;
        private final int port;
        private final int dispatcherPoolSize;

        public ServerWithAgentInstantiator(Resources resources, Filters filters, int port, int dispatcherPoolSize) {
            this.resources = resources;
            this.filters = filters;
            this.port = port;
            this.dispatcherPoolSize = dispatcherPoolSize;
        }

        public ServerActor instantiate() {
            try {
                return new ServerActor(this.resources, this.filters, this.port, this.dispatcherPoolSize);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate " + this.type() + " because: " + e.getMessage(), e);
            }
        }

        public Class<ServerActor> type() {
            return ServerActor.class;
        }
    }

    public static class ServerInstantiator
    implements ActorInstantiator<ServerActor> {
        private static final long serialVersionUID = 1085685844717413620L;
        private final Resources resources;
        private final Filters filters;
        private final int port;
        private final Configuration.Sizing sizing;
        private final Configuration.Timing timing;
        private final String channelMailboxTypeName;

        public ServerInstantiator(Resources resources, Filters filters, int port, Configuration.Sizing sizing, Configuration.Timing timing, String channelMailboxTypeName) {
            this.resources = resources;
            this.filters = filters;
            this.port = port;
            this.sizing = sizing;
            this.timing = timing;
            this.channelMailboxTypeName = channelMailboxTypeName;
        }

        public ServerActor instantiate() {
            try {
                return new ServerActor(this.resources, this.filters, this.port, this.sizing, this.timing, this.channelMailboxTypeName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate " + this.type() + " because: " + e.getMessage(), e);
            }
        }

        public Class<ServerActor> type() {
            return ServerActor.class;
        }
    }
}

