/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Address;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Returns;
import io.vlingo.actors.Stage;
import io.vlingo.actors.World;
import io.vlingo.common.BasicCompletes;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduled;
import io.vlingo.common.completes.SinkAndSourceBasedCompletes;
import io.vlingo.common.pool.ElasticResourcePool;
import io.vlingo.http.Context;
import io.vlingo.http.Filters;
import io.vlingo.http.Header;
import io.vlingo.http.Request;
import io.vlingo.http.RequestParser;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Configuration;
import io.vlingo.http.resource.Dispatcher;
import io.vlingo.http.resource.Resources;
import io.vlingo.http.resource.Server;
import io.vlingo.http.resource.agent.HttpAgent;
import io.vlingo.http.resource.agent.HttpRequestChannelConsumer;
import io.vlingo.http.resource.agent.HttpRequestChannelConsumerProvider;
import io.vlingo.wire.channel.RequestChannelConsumer;
import io.vlingo.wire.channel.RequestChannelConsumerProvider;
import io.vlingo.wire.channel.RequestResponseContext;
import io.vlingo.wire.fdx.bidirectional.ServerRequestResponseChannel;
import io.vlingo.wire.message.BasicConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBufferPool;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ServerActor
extends Actor
implements Server,
HttpRequestChannelConsumerProvider,
Scheduled<Object> {
    static final String ChannelName = "server-request-response-channel";
    static final String ServerName = "vlingo-http-server";
    private final HttpAgent agent;
    private final ServerRequestResponseChannel channel;
    private final Dispatcher[] dispatcherPool;
    private int dispatcherPoolIndex;
    private final Filters filters;
    private final int maxMessageSize;
    private final Map<String, RequestResponseHttpContext> requestsMissingContent;
    private final long requestMissingContentTimeout;
    private final ConsumerByteBufferPool responseBufferPool;
    private final World world;
    ResponseCompletes responseCompletes = new ResponseCompletes();

    public ServerActor(Resources resources, Filters filters, int port, int dispatcherPoolSize) throws Exception {
        long start = Instant.now().toEpochMilli();
        this.agent = HttpAgent.initialize(this, port, false, dispatcherPoolSize, this.logger());
        this.channel = null;
        this.filters = filters;
        this.dispatcherPoolIndex = 0;
        this.world = this.stage().world();
        this.requestsMissingContent = new HashMap<String, RequestResponseHttpContext>();
        this.maxMessageSize = 0;
        this.responseBufferPool = null;
        this.requestMissingContentTimeout = -1L;
        this.dispatcherPool = new Dispatcher[dispatcherPoolSize];
        for (int idx = 0; idx < dispatcherPoolSize; ++idx) {
            this.dispatcherPool[idx] = Dispatcher.startWith(this.stage(), resources);
        }
        long end = Instant.now().toEpochMilli();
        this.logger().info("Server vlingo-http-server is listening on port: " + port + " started in " + (end - start) + " ms");
        this.logResourceMappings(resources);
    }

    public ServerActor(Resources resources, Filters filters, int port, Configuration.Sizing sizing, Configuration.Timing timing, String channelMailboxTypeName) throws Exception {
        long start = Instant.now().toEpochMilli();
        this.agent = null;
        this.filters = filters;
        this.dispatcherPoolIndex = 0;
        this.world = this.stage().world();
        this.requestsMissingContent = new HashMap<String, RequestResponseHttpContext>();
        this.maxMessageSize = sizing.maxMessageSize;
        try {
            this.responseBufferPool = new ConsumerByteBufferPool(ElasticResourcePool.Config.of((int)sizing.maxBufferPoolSize), sizing.maxMessageSize);
            this.dispatcherPool = new Dispatcher[sizing.dispatcherPoolSize];
            for (int idx = 0; idx < sizing.dispatcherPoolSize; ++idx) {
                this.dispatcherPool[idx] = Dispatcher.startWith(this.stage(), resources);
            }
            this.channel = ServerRequestResponseChannel.start((Stage)this.stage(), (Address)this.stage().world().addressFactory().withHighId(ChannelName), (String)channelMailboxTypeName, (RequestChannelConsumerProvider)this, (int)port, (String)ChannelName, (int)sizing.processorPoolSize, (int)sizing.maxBufferPoolSize, (int)sizing.maxMessageSize, (long)timing.probeInterval, (long)timing.probeTimeout);
            long end = Instant.now().toEpochMilli();
            this.logger().info("Server vlingo-http-server is listening on port: " + port + " started in " + (end - start) + " ms");
            this.requestMissingContentTimeout = timing.requestMissingContentTimeout;
            this.logResourceMappings(resources);
        }
        catch (Exception e) {
            String message = "Failed to start server because: " + e.getMessage();
            this.logger().error(message, (Throwable)e);
            throw new IllegalStateException(message);
        }
    }

    @Override
    public Completes<Boolean> shutDown() {
        this.stop();
        return this.completes().with((Object)true);
    }

    @Override
    public Completes<Boolean> startUp() {
        if (this.requestMissingContentTimeout > 0L) {
            this.stage().scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, 1000L, this.requestMissingContentTimeout);
        }
        return this.completes().with((Object)true);
    }

    public RequestChannelConsumer requestChannelConsumer() {
        return this.httpRequestChannelConsumer();
    }

    @Override
    public HttpRequestChannelConsumer httpRequestChannelConsumer() {
        return new ServerRequestChannelConsumer(this.pooledDispatcher());
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.failTimedOutMissingContentRequests();
    }

    public void stop() {
        this.logger().info("Server stopping...");
        if (this.agent != null) {
            this.agent.close();
        } else {
            this.failTimedOutMissingContentRequests();
            this.channel.stop();
            this.channel.close();
            for (Dispatcher dispatcher : this.dispatcherPool) {
                dispatcher.stop();
            }
            this.filters.stop();
        }
        this.logger().info("Server stopped.");
        super.stop();
    }

    private void failTimedOutMissingContentRequests() {
        if (this.isStopped()) {
            return;
        }
        if (this.requestsMissingContent.isEmpty()) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String id : this.requestsMissingContent.keySet()) {
            RequestResponseHttpContext requestResponseHttpContext = this.requestsMissingContent.get(id);
            if (requestResponseHttpContext.requestResponseContext.hasConsumerData()) {
                RequestParser parser = (RequestParser)requestResponseHttpContext.requestResponseContext.consumerData();
                if (!parser.hasMissingContentTimeExpired(this.requestMissingContentTimeout)) continue;
                requestResponseHttpContext.requestResponseContext.consumerData(null);
                toRemove.add(id);
                requestResponseHttpContext.httpContext.completes.with((Object)Response.of(Response.Status.BadRequest, "Missing content with timeout."));
                requestResponseHttpContext.requestResponseContext.consumerData(null);
                continue;
            }
            toRemove.add(id);
        }
        for (String id : toRemove) {
            this.requestsMissingContent.remove(id);
        }
    }

    private void logResourceMappings(Resources resources) {
        Logger logger = this.logger();
        for (String resourceName : resources.namedResources.keySet()) {
            resources.namedResources.get(resourceName).log(logger);
        }
    }

    private Dispatcher pooledDispatcher() {
        if (this.dispatcherPoolIndex >= this.dispatcherPool.length) {
            this.dispatcherPoolIndex = 0;
        }
        return this.dispatcherPool[this.dispatcherPoolIndex++];
    }

    private class SinkBasedBasedResponseCompletes
    extends SinkAndSourceBasedCompletes<Response> {
        final Header correlationId;
        final boolean keepAlive;
        final boolean missingContent;
        final RequestResponseContext<?> requestResponseContext;

        SinkBasedBasedResponseCompletes(RequestResponseContext<?> requestResponseContext, boolean missingContent, Header correlationId, boolean keepAlive) {
            super(ServerActor.this.stage().scheduler());
            this.requestResponseContext = requestResponseContext;
            this.missingContent = missingContent;
            this.correlationId = correlationId;
            this.keepAlive = keepAlive;
        }

        public <O> Completes<O> with(O response) {
            Response unfilteredResponse = (Response)response;
            Response filtered = ServerActor.this.filters.process(unfilteredResponse);
            Response completedResponse = filtered.include(this.correlationId);
            boolean closeAfterResponse = this.closeAfterResponse(unfilteredResponse);
            if (ServerActor.this.agent == null) {
                ConsumerByteBuffer buffer = this.bufferFor(completedResponse);
                this.requestResponseContext.respondWith(completedResponse.into(buffer), closeAfterResponse);
            } else {
                this.requestResponseContext.respondWith((Object)completedResponse, closeAfterResponse);
            }
            return super.with(response);
        }

        private ConsumerByteBuffer bufferFor(Response response) {
            int size = response.size();
            if (size < ServerActor.this.maxMessageSize) {
                return ServerActor.this.responseBufferPool.acquire("ServerActor#SinkBasedBasedResponseCompletes#bufferFor");
            }
            return BasicConsumerByteBuffer.allocate((int)0, (int)(size + 1024));
        }

        private boolean closeAfterResponse(Response response) {
            if (this.missingContent) {
                return false;
            }
            char statusCategory = response.statusCode.charAt(0);
            if (statusCategory == '4' || statusCategory == '5') {
                return this.keepAlive;
            }
            boolean keepAliveAfterResponse = this.keepAlive || response.headerValueOr("Connection", "keep-alive").equalsIgnoreCase("keep-alive");
            return !keepAliveAfterResponse;
        }
    }

    private class BasicCompletedBasedResponseCompletes
    extends BasicCompletes<Response> {
        final Header correlationId;
        final boolean keepAlive;
        final boolean missingContent;
        final RequestResponseContext<?> requestResponseContext;

        BasicCompletedBasedResponseCompletes(RequestResponseContext<?> requestResponseContext, boolean missingContent, Header correlationId, boolean keepAlive) {
            super(ServerActor.this.stage().scheduler());
            this.requestResponseContext = requestResponseContext;
            this.missingContent = missingContent;
            this.correlationId = correlationId;
            this.keepAlive = keepAlive;
        }

        public <O> Completes<O> with(O response) {
            Response unfilteredResponse = (Response)response;
            Response filtered = ServerActor.this.filters.process(unfilteredResponse);
            Response completedResponse = filtered.include(this.correlationId);
            boolean closeAfterResponse = this.closeAfterResponse(unfilteredResponse);
            if (ServerActor.this.agent == null) {
                ConsumerByteBuffer buffer = this.bufferFor(completedResponse);
                this.requestResponseContext.respondWith(completedResponse.into(buffer), closeAfterResponse);
            } else {
                this.requestResponseContext.respondWith((Object)completedResponse, closeAfterResponse);
            }
            return this;
        }

        private ConsumerByteBuffer bufferFor(Response response) {
            int size = response.size();
            if (size < ServerActor.this.maxMessageSize) {
                return ServerActor.this.responseBufferPool.acquire("ServerActor#BasicCompletedBasedResponseCompletes#bufferFor");
            }
            return BasicConsumerByteBuffer.allocate((int)0, (int)(size + 1024));
        }

        private boolean closeAfterResponse(Response response) {
            if (this.missingContent) {
                return false;
            }
            char statusCategory = response.statusCode.charAt(0);
            if (statusCategory == '4' || statusCategory == '5') {
                return this.keepAlive;
            }
            boolean keepAliveAfterResponse = this.keepAlive || response.headerValueOr("Connection", "keep-alive").equalsIgnoreCase("keep-alive");
            return !keepAliveAfterResponse;
        }
    }

    private class ResponseCompletes {
        private ResponseCompletes() {
        }

        public Completes<Response> of(RequestResponseContext<?> requestResponseContext, boolean missingContent, Header correlationId, boolean keepAlive) {
            if (SinkAndSourceBasedCompletes.isToggleActive()) {
                return new SinkBasedBasedResponseCompletes(requestResponseContext, missingContent, correlationId, keepAlive);
            }
            return new BasicCompletedBasedResponseCompletes(requestResponseContext, missingContent, correlationId, keepAlive);
        }
    }

    private class RequestResponseHttpContext {
        final Context httpContext;
        final RequestResponseContext<?> requestResponseContext;

        RequestResponseHttpContext(RequestResponseContext<?> requestResponseContext, Context httpContext) {
            this.requestResponseContext = requestResponseContext;
            this.httpContext = httpContext;
        }
    }

    private class ServerRequestChannelConsumer
    implements HttpRequestChannelConsumer {
        private final Dispatcher dispatcher;

        ServerRequestChannelConsumer(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public void closeWith(RequestResponseContext<?> requestResponseContext, Object data) {
            if (data != null) {
                Request request = ServerActor.this.filters.process((Request)data);
                Completes<Response> completes = ServerActor.this.responseCompletes.of(requestResponseContext, false, request.headers.headerOf("X-Correlation-ID"), true);
                Context context = new Context(requestResponseContext, request, ServerActor.this.world.completesFor(Returns.value(completes)));
                this.dispatcher.dispatchFor(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(RequestResponseContext<?> requestResponseContext, ConsumerByteBuffer buffer) {
            boolean wasIncompleteContent = false;
            boolean missingContent = false;
            try {
                RequestParser parser;
                if (!requestResponseContext.hasConsumerData()) {
                    parser = RequestParser.parserFor(buffer.asByteBuffer());
                    requestResponseContext.consumerData((Object)parser);
                } else {
                    parser = (RequestParser)requestResponseContext.consumerData();
                    wasIncompleteContent = parser.isMissingContent();
                    parser.parseNext(buffer.asByteBuffer());
                }
                Context context = null;
                while (parser.hasFullRequest()) {
                    context = this.consume(requestResponseContext, parser.fullRequest(), wasIncompleteContent);
                }
                if (parser.isMissingContent() && !ServerActor.this.requestsMissingContent.containsKey(requestResponseContext.id())) {
                    missingContent = true;
                    if (context == null) {
                        Completes<Response> completes = ServerActor.this.responseCompletes.of((RequestResponseContext)requestResponseContext.typed(), true, null, true);
                        context = new Context(ServerActor.this.world.completesFor(Returns.value(completes)));
                    }
                    ServerActor.this.requestsMissingContent.put(requestResponseContext.id(), new RequestResponseHttpContext(requestResponseContext, context));
                }
            }
            catch (Exception e) {
                ServerActor.this.logger().error("Request parsing failed.", (Throwable)e);
                ServerActor.this.responseCompletes.of(requestResponseContext, missingContent, null, false).with((Object)Response.of(Response.Status.BadRequest, e.getMessage()));
            }
            finally {
                buffer.release();
            }
        }

        @Override
        public void consume(RequestResponseContext<?> requestResponseContext, Request request) {
            this.consume(requestResponseContext, request, false);
        }

        private Context consume(RequestResponseContext<?> requestResponseContext, Request request, boolean wasIncompleteContent) {
            boolean keepAlive = this.determineKeepAlive(requestResponseContext, request);
            Request filteredRequest = ServerActor.this.filters.process(request);
            Completes<Response> completes = ServerActor.this.responseCompletes.of(requestResponseContext, false, filteredRequest.headers.headerOf("X-Correlation-ID"), keepAlive);
            Context context = new Context(requestResponseContext, filteredRequest, ServerActor.this.world.completesFor(Returns.value(completes)));
            this.dispatcher.dispatchFor(context);
            if (wasIncompleteContent) {
                ServerActor.this.requestsMissingContent.remove(requestResponseContext.id());
            }
            return context;
        }

        private boolean determineKeepAlive(RequestResponseContext<?> requestResponseContext, Request unfilteredRequest) {
            boolean keepAlive = unfilteredRequest.headerValueOr("Connection", "keep-alive").equalsIgnoreCase("keep-alive");
            return keepAlive;
        }
    }
}

