/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.http.Body;
import io.vlingo.http.Response;
import io.vlingo.http.resource.ResourceHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class StaticFilesResource
extends ResourceHandler {
    private String rootPath;

    public void serveFile(String contentFile, String root, String validSubPaths) {
        if (this.rootPath == null) {
            String slash = root.endsWith("/") ? "" : "/";
            this.rootPath = root + slash;
        }
        String contentPath = this.rootPath + this.context.request.uri;
        try {
            byte[] fileContent = this.readFile(contentPath);
            this.completes().with((Object)Response.of(Response.Status.Ok, Body.from(fileContent, Body.Encoding.UTF8).content()));
        }
        catch (IOException e) {
            this.completes().with((Object)Response.of(Response.Status.InternalServerError));
        }
        catch (IllegalArgumentException e) {
            this.completes().with((Object)Response.of(Response.Status.NotFound));
        }
    }

    private byte[] readFile(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            return Files.readAllBytes(file.toPath());
        }
        throw new IllegalArgumentException("File not found.");
    }
}

