/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.agent;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.vlingo.actors.Logger;
import io.vlingo.http.Body;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.RequestHeader;
import io.vlingo.http.Response;
import io.vlingo.http.Version;
import io.vlingo.http.resource.agent.HttpRequestChannelConsumerProvider;
import io.vlingo.wire.channel.RequestResponseContext;
import io.vlingo.wire.channel.ResponseSenderChannel;
import io.vlingo.wire.message.ConsumerByteBuffer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class AgentHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements ResponseSenderChannel {
    private static final String AGENT_CONTEXT_NAME = "$AGENT_CONTEXT";
    private static final AttributeKey<AgentChannelContext> AGENT_CONTEXT = AttributeKey.exists((String)"$AGENT_CONTEXT") ? AttributeKey.valueOf((String)"$AGENT_CONTEXT") : AttributeKey.newInstance((String)"$AGENT_CONTEXT");
    private String contextInstanceId;
    private final Logger logger;
    private final HttpRequestChannelConsumerProvider provider;
    private static final AtomicLong nextInstanceId = new AtomicLong(0L);
    private final long instanceId;

    AgentHandler(HttpRequestChannelConsumerProvider provider, Logger logger) {
        this.provider = provider;
        this.logger = logger;
        this.instanceId = nextInstanceId.incrementAndGet();
    }

    public void channelActive(ChannelHandlerContext context) throws Exception {
        if (context.channel().isActive()) {
            this.agentChannelContext(context);
        }
    }

    public void channelReadComplete(ChannelHandlerContext context) {
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        this.logger.error("AgentHandler failured because: " + cause.getMessage() + ".\nClosing context: " + this.contextInstanceId(context), cause);
        context.close();
    }

    protected void channelRead0(ChannelHandlerContext context, FullHttpRequest request) throws Exception {
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            AgentHandler.send100Continue(context);
        }
        this.provider.httpRequestChannelConsumer().consume(this.agentChannelContext(context), this.toConsumable(request));
    }

    public void channelUnregistered(ChannelHandlerContext context) throws Exception {
        super.channelUnregistered(context);
    }

    public void abandon(RequestResponseContext<?> context) {
        ChannelHandlerContext channelContext = ((AgentChannelContext)context).channelHandlerContext;
        channelContext.close();
    }

    public void respondWith(RequestResponseContext<?> context, ConsumerByteBuffer buffer) {
        this.respondWith(context, buffer, false);
    }

    public void respondWith(RequestResponseContext<?> context, ConsumerByteBuffer buffer, boolean closeFollowing) {
        AgentChannelContext agentChannelContext = (AgentChannelContext)context;
        ChannelHandlerContext channelHandlerContext = agentChannelContext.channelHandlerContext();
        boolean keepAlive = this.writeResponse(channelHandlerContext, buffer, !closeFollowing);
        if (!keepAlive) {
            channelHandlerContext.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            channelHandlerContext.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
        }
    }

    public void respondWith(RequestResponseContext<?> context, Object response, boolean closeFollowing) {
        Response typedResponse = this.toResponse(response);
        FullHttpResponse writable = this.toWritable(typedResponse);
        ChannelHandlerContext channelHandlerContext = this.agentChannelContext(context).channelHandlerContext();
        channelHandlerContext.write((Object)writable);
        if (closeFollowing) {
            channelHandlerContext.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            channelHandlerContext.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
        }
    }

    private AgentChannelContext agentChannelContext(ChannelHandlerContext context) {
        Channel channel = context.channel();
        if (!channel.hasAttr(AGENT_CONTEXT)) {
            channel.attr(AGENT_CONTEXT).set((Object)new AgentChannelContext(context, this));
        }
        return (AgentChannelContext)((Object)channel.attr(AGENT_CONTEXT).get());
    }

    private AgentChannelContext agentChannelContext(RequestResponseContext<?> context) {
        return (AgentChannelContext)context;
    }

    private String contextInstanceId(ChannelHandlerContext context) {
        if (this.contextInstanceId == null) {
            this.contextInstanceId = context.name() + ":" + this.instanceId;
        }
        return this.contextInstanceId;
    }

    private static void send100Continue(ChannelHandlerContext context) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        context.write((Object)response);
    }

    private Request toConsumable(FullHttpRequest request) throws Exception {
        Method consumableMethod = Method.from(request.method().name());
        URI consumableURI = new URI(request.uri());
        Version consumableVersion = Version.Http1_1;
        Header.Headers<RequestHeader> headers = Header.Headers.empty();
        for (Map.Entry entry : request.headers()) {
            RequestHeader header = RequestHeader.of((String)entry.getKey(), (String)entry.getValue());
            headers.add(header);
        }
        ByteBuf content = request.content();
        Body body = content.isReadable() ? Body.from(content.toString(CharsetUtil.UTF_8)) : Body.Empty;
        Request consumableRequest = Request.from(consumableMethod, consumableURI, consumableVersion, headers, body);
        return consumableRequest;
    }

    private <T> Response toResponse(T response) {
        return (Response)response;
    }

    private FullHttpResponse toWritable(Response response) {
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.status.code), Unpooled.copiedBuffer((CharSequence)response.entity.content(), (Charset)CharsetUtil.UTF_8), false);
        for (Header header : response.headers) {
            httpResponse.headers().set(header.name, (Object)header.value);
        }
        return httpResponse;
    }

    private boolean writeResponse(ChannelHandlerContext channelHandlerContext, ConsumerByteBuffer buffer, boolean keepAlive) {
        ByteBuf replyBuffer = channelHandlerContext.alloc().buffer(buffer.limit());
        replyBuffer.writeBytes(buffer.asByteBuffer());
        channelHandlerContext.write((Object)replyBuffer);
        return keepAlive;
    }

    private static class AgentChannelContext
    extends ChannelInboundHandlerAdapter
    implements RequestResponseContext<ConsumerByteBuffer> {
        private static final AtomicLong contextId = new AtomicLong(0L);
        private final ChannelHandlerContext channelHandlerContext;
        private Object closingData;
        private Object consumerData;
        private final String id;
        private final ResponseSenderChannel sender;

        AgentChannelContext(ChannelHandlerContext channelHandlerContext, ResponseSenderChannel sender) {
            this.channelHandlerContext = channelHandlerContext;
            this.sender = sender;
            this.id = "" + contextId.incrementAndGet();
        }

        public <T> T consumerData() {
            return (T)this.consumerData;
        }

        public <T> T consumerData(T workingData) {
            this.consumerData = workingData;
            return workingData;
        }

        public boolean hasConsumerData() {
            return this.consumerData != null;
        }

        public String id() {
            return this.id;
        }

        public ResponseSenderChannel sender() {
            return this.sender;
        }

        public void whenClosing(Object data) {
            this.closingData = data;
        }

        ChannelHandlerContext channelHandlerContext() {
            return this.channelHandlerContext;
        }
    }
}

