/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.agent;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslContext;
import io.vlingo.actors.Logger;
import io.vlingo.http.resource.agent.AgentHandler;
import io.vlingo.http.resource.agent.HttpRequestChannelConsumerProvider;

public class AgentInitializer
extends ChannelInitializer<SocketChannel> {
    private final Logger logger;
    private final HttpRequestChannelConsumerProvider provider;
    private final SslContext sslContext;

    AgentInitializer(HttpRequestChannelConsumerProvider provider, SslContext sslContext, Logger logger) {
        this.provider = provider;
        this.sslContext = sslContext;
        this.logger = logger;
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        if (this.sslContext != null) {
            channelPipeline.addLast(new ChannelHandler[]{this.sslContext.newHandler(channel.alloc())});
        }
        channelPipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        channelPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
        channelPipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        channelPipeline.addLast(new ChannelHandler[]{new AgentHandler(this.provider, this.logger)});
    }
}

