/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.agent;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.vlingo.actors.Logger;
import io.vlingo.http.resource.agent.AgentInitializer;
import io.vlingo.http.resource.agent.HttpRequestChannelConsumerProvider;
import java.io.File;

public class HttpAgent {
    private final Channel channel;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public static HttpAgent initialize(HttpRequestChannelConsumerProvider provider, int port, boolean useSSL, int numberOfThreads, Logger logger) throws Exception {
        SslContext sslContext = useSSL ? HttpAgent.sslContext() : null;
        OptimalTransport optimalTransport = HttpAgent.optimalTransport(logger);
        EventLoopGroup bossGroup = HttpAgent.eventLoopGroup(optimalTransport, numberOfThreads, logger);
        EventLoopGroup workerGroup = HttpAgent.eventLoopGroup(optimalTransport, logger);
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(HttpAgent.serverSocketChannelType(optimalTransport, logger))).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new AgentInitializer(provider, sslContext, logger));
        return new HttpAgent(bootstrap.bind(port).sync().channel(), bossGroup, workerGroup);
    }

    public void close() {
        this.channel.close().addListener(outcome -> {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        });
    }

    private static SslContext sslContext() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        return SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
    }

    private HttpAgent(Channel channel, EventLoopGroup bossGroup, EventLoopGroup workerGroup) throws Exception {
        this.channel = channel;
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
    }

    private static EventLoopGroup eventLoopGroup(OptimalTransport optimalTransport, Logger logger) {
        switch (optimalTransport) {
            case Epoll: {
                logger.debug("HttpAgent using EpollEventLoopGroup");
                return new EpollEventLoopGroup();
            }
        }
        logger.debug("HttpAgent using NioEventLoopGroup");
        return new NioEventLoopGroup();
    }

    private static EventLoopGroup eventLoopGroup(OptimalTransport optimalTransport, int processorPoolSize, Logger logger) {
        switch (optimalTransport) {
            case Epoll: {
                logger.debug("HttpAgent using EpollEventLoopGroup " + processorPoolSize);
                return new EpollEventLoopGroup(processorPoolSize);
            }
        }
        logger.debug("HttpAgent using NioEventLoopGroup " + processorPoolSize);
        return new NioEventLoopGroup(processorPoolSize);
    }

    private static OptimalTransport optimalTransport(Logger logger) {
        String osName = System.getProperty("os.name");
        logger.debug("HttpAgent running on " + osName);
        if (osName.toLowerCase().contains("linux")) {
            return OptimalTransport.Epoll;
        }
        return OptimalTransport.NIO;
    }

    private static Class<? extends ServerSocketChannel> serverSocketChannelType(OptimalTransport optimalTransport, Logger logger) {
        switch (optimalTransport) {
            case Epoll: {
                logger.debug("HttpAgent using EpollServerSocketChannel");
                return EpollServerSocketChannel.class;
            }
        }
        logger.debug("HttpAgent using NioServerSocketChannel");
        return NioServerSocketChannel.class;
    }

    private static enum OptimalTransport {
        NIO,
        Epoll;

    }
}

