/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.feed;

import io.vlingo.actors.Actor;
import io.vlingo.actors.World;
import io.vlingo.http.Response;
import io.vlingo.http.resource.ResourceHandler;
import io.vlingo.http.resource.feed.FeedProducer;
import io.vlingo.http.resource.feed.FeedProductRequest;
import java.util.HashMap;
import java.util.Map;

public class FeedResource
extends ResourceHandler {
    private Map<String, FeedProducer> producers;
    private final World world;

    public FeedResource(World world) {
        this.world = world;
        this.producers = new HashMap<String, FeedProducer>(2);
    }

    public void feed(String feedName, String feedProductId, Class<? extends Actor> feedProducerClass, int feedProductElements) {
        FeedProducer producer = this.feedProducer(feedName, feedProducerClass);
        if (producer == null) {
            this.completes().with((Object)Response.of(Response.Status.NotFound, "Feed '" + feedName + "' does not exist."));
        } else {
            producer.produceFeedFor(new FeedProductRequest(this.context(), feedName, feedProductId, feedProductElements));
        }
    }

    private FeedProducer feedProducer(String feedName, Class<? extends Actor> feedProducerClass) {
        FeedProducer producer = this.producers.get(feedName);
        if (producer == null) {
            producer = FeedProducer.using(this.world.stage(), feedProducerClass);
            this.producers.put(feedName, producer);
        }
        return producer;
    }
}

