/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.sse;

import io.vlingo.http.Header;
import io.vlingo.http.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageEvent {
    public static final int NoRetry = -1;
    public final String comment;
    public final String data;
    public final String event;
    public final String id;
    public final int retry;

    public static List<MessageEvent> from(Response response) {
        int currentIndex;
        Header header = response.headerOf("Content-Type");
        if (header == null || !header.value.equals("text/event-stream")) {
            Collections.emptyList();
        }
        ArrayList<MessageEvent> events = new ArrayList<MessageEvent>(2);
        String[] rawContent = response.entity.content().split("\n");
        int startIndex = 0;
        boolean isEvent = false;
        for (currentIndex = 0; currentIndex < rawContent.length; ++currentIndex) {
            if (rawContent[currentIndex].length() > 0) {
                if (isEvent) continue;
                isEvent = true;
                startIndex = currentIndex;
                continue;
            }
            if (!isEvent) continue;
            isEvent = false;
            events.add(MessageEvent.eventFrom(rawContent, startIndex, currentIndex - 1));
            startIndex = 0;
        }
        if (isEvent) {
            events.add(MessageEvent.eventFrom(rawContent, startIndex, currentIndex - 1));
        }
        return events;
    }

    private static MessageEvent eventFrom(String[] rawContent, int startIndex, int endIndex) {
        String comment = null;
        String data = null;
        String event = null;
        String id = null;
        int retry = -1;
        block26: for (int currentIndex = startIndex; currentIndex <= endIndex; ++currentIndex) {
            int colon = rawContent[currentIndex].indexOf(58);
            if (colon > 0) {
                String field = rawContent[currentIndex].substring(0, colon).trim();
                String value = rawContent[currentIndex].length() > colon + 1 ? rawContent[currentIndex].substring(colon + 1).trim() : "";
                switch (field) {
                    case "data": {
                        data = data == null ? value : data + "\n" + value;
                        break;
                    }
                    case "event": {
                        event = value;
                        break;
                    }
                    case "id": {
                        id = value;
                        break;
                    }
                    case "retry": {
                        try {
                            retry = Integer.parseInt(value);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                continue;
            }
            if (colon == 0) {
                if (rawContent[currentIndex].length() <= 0) continue;
                comment = rawContent[currentIndex].substring(1).trim();
                continue;
            }
            switch (rawContent[currentIndex].trim()) {
                case "data": {
                    continue block26;
                }
                case "event": {
                    continue block26;
                }
                case "id": {
                    id = "";
                    continue block26;
                }
                case "retry": {
                    retry = -1;
                }
            }
        }
        return new MessageEvent(id, event, data, retry, comment);
    }

    public MessageEvent(String id, String event, String data, int retry, String comment) {
        this.id = id;
        this.event = event;
        this.data = data;
        this.retry = retry;
        this.comment = comment;
    }

    public boolean endOfStream() {
        return this.id != null && this.id.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasEvent() {
        return this.event != null && !this.event.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public boolean hasRetry() {
        return this.retry > 0;
    }
}

