/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.sse;

import io.vlingo.http.Header;
import io.vlingo.http.Response;
import io.vlingo.http.ResponseHeader;
import io.vlingo.http.resource.Configuration;
import io.vlingo.http.resource.sse.SseEvent;
import io.vlingo.wire.channel.RequestResponseContext;
import io.vlingo.wire.message.BasicConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBuffer;
import java.util.Arrays;
import java.util.Collection;

public class SseClient {
    private static final ResponseHeader CacheControl = ResponseHeader.of("Cache-Control", "no-cache");
    private static final ResponseHeader Connection = ResponseHeader.of("Connection", "keep-alive");
    private static final ResponseHeader ContentType = ResponseHeader.of("Content-Type", "text/event-stream;charset=utf-8");
    private static final Header.Headers<ResponseHeader> headers = Header.Headers.empty();
    private final StringBuilder builder;
    private final RequestResponseContext<?> context;
    private final int maxMessageSize;

    public SseClient(RequestResponseContext<?> context, Header.Headers<ResponseHeader> extraHeaders) {
        this.context = context;
        headers.and(extraHeaders);
        this.builder = new StringBuilder();
        this.maxMessageSize = Configuration.instance.sizing().maxMessageSize;
        this.sendInitialResponse();
    }

    public SseClient(RequestResponseContext<?> context) {
        this(context, Header.Headers.empty());
    }

    public void close() {
        this.context.abandon();
    }

    public String id() {
        return this.context.id();
    }

    public void send(SseEvent event) {
        this.send(event.sendable());
    }

    public void send(SseEvent ... events) {
        this.send(Arrays.asList(events));
    }

    public void send(Collection<SseEvent> events) {
        String entity = this.flatten(events);
        this.send(entity);
    }

    private void send(String entity) {
        BasicConsumerByteBuffer buffer = BasicConsumerByteBuffer.allocate((int)1, (int)this.maxMessageSize);
        this.context.respondWith(buffer.put(entity.getBytes()).flip());
    }

    private void sendInitialResponse() {
        try {
            Response response = Response.of(Response.Status.Ok, headers.copy());
            BasicConsumerByteBuffer buffer = BasicConsumerByteBuffer.allocate((int)1, (int)this.maxMessageSize);
            this.context.respondWith(response.into((ConsumerByteBuffer)buffer));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String flatten(Collection<SseEvent> events) {
        this.builder.delete(0, this.builder.length());
        for (SseEvent event : events) {
            this.builder.append(event.sendable());
        }
        return this.builder.toString();
    }

    static {
        headers.and(Connection).and(ContentType).and(CacheControl);
    }
}

