/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.sse;

public class SseEvent {
    public static final int NoRetry = -1;
    public final String comment;
    public final String data;
    public final String event;
    public final String id;
    public final int retry;

    public SseEvent(String id, String event) {
        this(id, event, null, -1, null);
    }

    public SseEvent(String id, String event, String data) {
        this(id, event, data, -1, null);
    }

    public SseEvent(String id, String event, String data, int retry, String comment) {
        this.id = id;
        this.event = event;
        this.data = data;
        this.retry = retry;
        this.comment = comment;
    }

    public boolean endOfStream() {
        return this.id != null && this.id.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public String sendable() {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.comment != null) {
            builder.append(": ").append(this.flatten(this.comment)).append('\n');
        }
        if (this.id != null) {
            if (this.id.length() > 0) {
                builder.append("id: ").append(this.flatten(this.id)).append('\n');
            } else {
                builder.append("id").append('\n');
            }
        }
        if (this.event != null) {
            builder.append("event: ").append(this.flatten(this.event)).append('\n');
        }
        if (this.data != null) {
            for (String value : this.data.split("\n")) {
                builder.append("data: ").append(value).append('\n');
            }
        }
        if (this.retry >= 0) {
            builder.append("retry: ").append(this.retry).append('\n');
        }
        return builder.append('\n').toString();
    }

    private String flatten(String text) {
        return text.replace("\n", "");
    }

    public static class Builder {
        public String comment;
        public String data;
        public String event;
        public String id;
        public int retry = -1;

        public static Builder instance() {
            return new Builder();
        }

        public Builder clear() {
            this.data = null;
            this.event = null;
            this.id = null;
            this.retry = -1;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder data(String data) {
            this.data = this.data == null ? data : this.data + "\n" + data;
            return this;
        }

        public Builder endOfStream() {
            this.id = "";
            return this;
        }

        public Builder event(String event) {
            this.event = event;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder id(int id) {
            this.id = String.valueOf(id);
            return this;
        }

        public Builder id(long id) {
            this.id = String.valueOf(id);
            return this;
        }

        public Builder retry(int retry) {
            this.retry = retry;
            return this;
        }

        public SseEvent toEvent() {
            return new SseEvent(this.id, this.event, this.data, this.retry, this.comment);
        }
    }
}

