/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource.sse;

import io.vlingo.http.resource.sse.SseClient;

public class SseSubscriber {
    private final SseClient client;
    private final String correlationId;
    private String currentEventId;
    private final String streamName;

    public SseSubscriber(String streamName, SseClient client, String correlationId, String lastEventId) {
        this.streamName = streamName;
        this.client = client;
        this.correlationId = correlationId;
        this.currentEventId = lastEventId;
    }

    public SseSubscriber(String streamName, SseClient client) {
        this(streamName, client, "", "");
    }

    public SseClient client() {
        return this.client;
    }

    public void close() {
        this.client.close();
    }

    public boolean isCompatibleWith(String streamName) {
        return this.streamName.equals(streamName);
    }

    public String correlationId() {
        return this.correlationId;
    }

    public boolean hasCorrelationId() {
        return this.correlationId != null && !this.correlationId.isEmpty();
    }

    public String currentEventId() {
        return this.currentEventId;
    }

    public void currentEventId(String currentEventId) {
        this.currentEventId = currentEventId;
    }

    public boolean hasCurrentEventId() {
        return this.currentEventId != null && !this.currentEventId.isEmpty();
    }

    public String id() {
        return this.client.id();
    }

    public String streamName() {
        return this.streamName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SseSubscriber [");
        sb.append("stream='").append(this.streamName()).append('\'');
        if (this.hasCorrelationId()) {
            sb.append(", correlationId='").append(this.correlationId()).append('\'');
        }
        if (this.hasCurrentEventId()) {
            sb.append(", currentEventId='").append(this.currentEventId()).append('\'');
        }
        if (this.client.id() != null) {
            sb.append(", client=").append(this.client.id());
        }
        sb.append(']');
        return sb.toString();
    }
}

