/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorFactory;
import io.vlingo.actors.Address;
import io.vlingo.actors.AddressFactory;
import io.vlingo.actors.Configuration;
import io.vlingo.actors.Definition;
import io.vlingo.actors.GridActorOperations;
import io.vlingo.actors.GridAddressFactory;
import io.vlingo.actors.GridMailbox;
import io.vlingo.actors.GridRuntime;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.Message;
import io.vlingo.actors.Relocatable;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Supervisor;
import io.vlingo.actors.World;
import io.vlingo.cluster.model.Properties;
import io.vlingo.common.identity.IdentityGeneratorType;
import io.vlingo.lattice.grid.GridNodeBootstrap;
import io.vlingo.lattice.grid.application.GridActorControl;
import io.vlingo.lattice.grid.application.QuorumObserver;
import io.vlingo.lattice.grid.hashring.HashRing;
import io.vlingo.lattice.grid.hashring.MurmurSortedMapHashRing;
import io.vlingo.wire.node.Id;
import java.util.List;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class Grid
extends Stage
implements GridRuntime {
    private static final int GridStageBuckets = 32;
    private static final int GridStageInitialCapacity = 16384;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(Grid.class);
    private static final String INSTANCE_NAME = UUID.randomUUID().toString();
    private final GridNodeBootstrap gridNodeBootstrap;
    private final HashRing<Id> hashRing = new MurmurSortedMapHashRing<Id>(100);
    private Id nodeId;
    private GridActorControl.Outbound outbound;
    private volatile boolean hasQuorum;
    private final long clusterHealthCheckInterval;

    public static Grid instance(World world) {
        return (Grid)world.resolveDynamic(INSTANCE_NAME, Grid.class);
    }

    public static Grid start(String worldName, String gridNodeName) throws Exception {
        return Grid.start(worldName, Configuration.define(), Properties.open(), gridNodeName);
    }

    public static Grid start(World world, String gridNodeName) throws Exception {
        return Grid.start(world, (AddressFactory)new GridAddressFactory(IdentityGeneratorType.RANDOM), Properties.open(), gridNodeName);
    }

    public static Grid start(String worldName, Configuration worldConfiguration, String gridNodeName) throws Exception {
        return Grid.start(worldName, worldConfiguration, Properties.open(), gridNodeName);
    }

    public static Grid start(String worldName, Configuration worldConfiguration, Properties clusterProperties, String gridNodeName) throws Exception {
        return Grid.start(worldName, (AddressFactory)new GridAddressFactory(IdentityGeneratorType.RANDOM), worldConfiguration, clusterProperties, gridNodeName);
    }

    public static Grid start(World world, Properties clusterProperties, String gridNodeName) throws Exception {
        return Grid.start(world, (AddressFactory)new GridAddressFactory(IdentityGeneratorType.RANDOM), clusterProperties, gridNodeName);
    }

    public static Grid start(String worldName, AddressFactory addressFactory, Configuration worldConfiguration, Properties clusterProperties, String gridNodeName) throws Exception {
        World world = World.start((String)worldName, (Configuration)worldConfiguration);
        return new Grid(world, addressFactory, clusterProperties, gridNodeName);
    }

    public static Grid start(World world, AddressFactory addressFactory, Properties clusterProperties, String gridNodeName) throws Exception {
        return new Grid(world, addressFactory, clusterProperties, gridNodeName);
    }

    public Grid(World world, AddressFactory addressFactory, Properties clusterProperties, String gridNodeName) throws Exception {
        super(world, addressFactory, gridNodeName, 32, 16384);
        this.extenderStartDirectoryScanner();
        this.gridNodeBootstrap = GridNodeBootstrap.boot(this, gridNodeName, clusterProperties, false);
        this.hasQuorum = false;
        this.clusterHealthCheckInterval = clusterProperties.clusterHealthCheckInterval();
        world.registerDynamic(INSTANCE_NAME, (Object)this);
    }

    protected ActorFactory.MailboxWrapper mailboxWrapper() {
        return (address, mailbox) -> new GridMailbox(mailbox, this.nodeId, address, this.hashRing, this.outbound);
    }

    public void terminate() {
        this.world().terminate();
    }

    @Override
    public void quorumAchieved() {
        this.hasQuorum = true;
    }

    @Override
    public void quorumLost() {
        this.hasQuorum = false;
    }

    @Override
    public Actor actorAt(Address address) {
        return this.directory.actorOf(address);
    }

    @Override
    public Stage asStage() {
        return this;
    }

    <T> T actorThunkFor(Class<T> protocol, Definition definition, Address address) {
        Mailbox actorMailbox = this.allocateMailbox(definition, address, null);
        actorMailbox.suspendExceptFor("GridActor.Resume", new Class[]{Relocatable.class});
        Stage.ActorProtocolActor<T> actor = this.actorProtocolFor(protocol, definition, definition.parentOr(this.world.defaultParent()), address, actorMailbox, definition.supervisor(), definition.loggerOr(this.world.defaultLogger()));
        return (T)actor.protocolActor();
    }

    @Override
    public GridNodeBootstrap gridNodeBootstrap() {
        return this.gridNodeBootstrap;
    }

    @Override
    public HashRing<Id> hashRing() {
        return this.hashRing;
    }

    @Override
    public void nodeJoined(Id newNode) {
        if (this.nodeId.equals((Object)newNode)) {
            return;
        }
        HashRing<Id> copy = this.hashRing.copy();
        this.hashRing.includeNode(newNode);
        this.directory.addresses().stream().filter(address -> address.isDistributable() && this.shouldRelocateTo(copy, (Address)address, newNode)).forEach(address -> {
            Actor actor = this.directory.actorOf(address);
            if (!GridActorOperations.isSuspendedForRelocation(actor)) {
                logger.debug("Relocating actor [{}] to [{}]", address, (Object)newNode);
                GridActorOperations.suspendForRelocation(actor);
                this.outbound.relocate(newNode, this.nodeId, Definition.SerializationProxy.from((Definition)actor.definition()), (Address)address, GridActorOperations.supplyRelocationSnapshot(actor), (List<? extends Message>)GridActorOperations.pending(actor));
            }
        });
    }

    private boolean shouldRelocateTo(HashRing<Id> previous, Address address, Id newNode) {
        return Grid.isAssignedTo(previous, address, this.nodeId) && Grid.isAssignedTo(this.hashRing, address, newNode);
    }

    private static boolean isAssignedTo(HashRing<Id> ring, Address a, Id node) {
        return node.equals((Object)ring.nodeOf(a.idString()));
    }

    @Override
    public QuorumObserver quorumObserver() {
        return this;
    }

    @Override
    public void setOutbound(GridActorControl.Outbound outbound) {
        this.outbound = outbound;
    }

    @Override
    public void setNodeId(Id nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public ClassLoader worldClassLoader() {
        return this.world().classLoader();
    }

    protected <T> Stage.ActorProtocolActor<T> actorProtocolFor(Class<T> protocol, Definition definition, Actor parent, Address maybeAddress, Mailbox maybeMailbox, Supervisor maybeSupervisor, Logger logger) {
        Address address = maybeAddress == null ? this.addressFactory().unique() : maybeAddress;
        Id node = this.hashRing.nodeOf(address.idString());
        Mailbox mailbox = this.maybeRemoteMailbox(address, definition, maybeMailbox, () -> this.outbound.start(node, this.nodeId, protocol, address, Definition.SerializationProxy.from((Definition)definition)));
        return super.actorProtocolFor(protocol, definition, parent, address, mailbox, maybeSupervisor, logger);
    }

    protected Stage.ActorProtocolActor<Object>[] actorProtocolFor(Class<?>[] protocols, Definition definition, Actor parent, Address maybeAddress, Mailbox maybeMailbox, Supervisor maybeSupervisor, Logger logger) {
        Address address = maybeAddress == null ? this.addressFactory().unique() : maybeAddress;
        Id node = this.hashRing.nodeOf(address.idString());
        Mailbox mailbox = this.maybeRemoteMailbox(address, definition, maybeMailbox, () -> this.outbound.start(node, this.nodeId, protocols[0], address, Definition.SerializationProxy.from((Definition)definition)));
        return super.actorProtocolFor((Class[])protocols, definition, parent, address, mailbox, maybeSupervisor, logger);
    }

    private Mailbox maybeRemoteMailbox(Address address, Definition definition, Mailbox maybeMailbox, Runnable out) {
        Mailbox __mailbox;
        while (!this.hasQuorum && address.isDistributable()) {
            logger.debug("Mailbox allocation waiting for cluster quorum...");
            try {
                Thread.sleep(this.clusterHealthCheckInterval);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Id node = this.hashRing.nodeOf(address.idString());
        if (node != null && !node.equals((Object)this.nodeId)) {
            out.run();
            __mailbox = this.allocateMailbox(definition, address, maybeMailbox);
            if (!__mailbox.isSuspendedFor("GridActor.Resume")) {
                __mailbox.suspendExceptFor("GridActor.Resume", new Class[]{Relocatable.class});
            }
        } else {
            __mailbox = maybeMailbox;
        }
        return __mailbox;
    }
}

