/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.Message;
import io.vlingo.actors.Relocatable;
import io.vlingo.actors.Stage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class GridActorOperations {
    static final String Resume = "GridActor.Resume";

    public static final <S> void applyRelocationSnapshot(Stage stage, Actor actor, S snapshot) {
        Relocatable consumer = (Relocatable)stage.actorAs(actor, Relocatable.class);
        consumer.stateSnapshot(snapshot);
    }

    public static final <S> S supplyRelocationSnapshot(Actor actor) {
        return (S)actor.stateSnapshot();
    }

    public static final List<Message> pending(Actor actor) {
        Mailbox mailbox = actor.lifeCycle.environment.mailbox;
        return StreamSupport.stream(Spliterators.spliterator(new PendingMessageIterator(mailbox), (long)mailbox.pendingMessages(), 16), false).collect(Collectors.toCollection(ArrayList::new));
    }

    public static final void resumeFromRelocation(Actor actor) {
        actor.lifeCycle.environment.mailbox.resume(Resume);
    }

    public static final boolean isSuspendedForRelocation(Actor actor) {
        return actor.lifeCycle.environment.mailbox.isSuspendedFor(Resume);
    }

    public static final void suspendForRelocation(Actor actor) {
        actor.lifeCycle.environment.mailbox.suspendExceptFor(Resume, new Class[]{Relocatable.class});
    }

    private static class PendingMessageIterator
    implements Iterator<Message> {
        private final Mailbox mailbox;
        private Message next = null;

        PendingMessageIterator(Mailbox mailbox) {
            this.mailbox = mailbox;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.mailbox.receive();
            }
            return this.next != null;
        }

        @Override
        public Message next() {
            if (this.hasNext()) {
                Message __next = this.next;
                this.next = null;
                return __next;
            }
            throw new NoSuchElementException();
        }
    }
}

