/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Address;
import io.vlingo.actors.GridAddress;
import io.vlingo.actors.UUIDAddressFactory;
import io.vlingo.common.identity.IdentityGeneratorType;
import java.util.UUID;

public final class GridAddressFactory
extends UUIDAddressFactory {
    private static final Address None = new GridAddress(null, "(none)");

    public GridAddressFactory(IdentityGeneratorType type) {
        super(type);
    }

    public <T> Address findableBy(T id) {
        return new GridAddress((UUID)id);
    }

    public Address from(long reservedId, String name) {
        return new GridAddress(this.uuidFrom(reservedId), name);
    }

    public Address from(String idString) {
        return new GridAddress(UUID.fromString(idString));
    }

    public Address from(String idString, String name) {
        return new GridAddress(UUID.fromString(idString), name);
    }

    public Address unique() {
        return this.from(super.unique().idString());
    }

    public Address uniqueWith(String name) {
        return this.from(super.uniqueWith(name).idString(), name);
    }

    public Address uniquePrefixedWith(String prefixedWith) {
        return new GridAddress((UUID)super.uniquePrefixedWith(prefixedWith).idTyped(), prefixedWith, true);
    }

    public Address none() {
        return None;
    }

    public Address withHighId() {
        throw new UnsupportedOperationException("Unsupported for GridAddress.");
    }

    public Address withHighId(String name) {
        throw new UnsupportedOperationException("Unsupported for GridAddress.");
    }

    public long testNextIdValue() {
        throw new UnsupportedOperationException("Unsupported for GridAddress.");
    }
}

