/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Address;
import io.vlingo.actors.Definition;
import io.vlingo.actors.LocalMessage;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.Message;
import io.vlingo.actors.Returns;
import io.vlingo.actors.Stoppable;
import io.vlingo.common.SerializableConsumer;
import io.vlingo.lattice.grid.application.GridActorControl;
import io.vlingo.lattice.grid.hashring.HashRing;
import io.vlingo.wire.node.Id;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridMailbox
implements Mailbox {
    private static final Logger log = LoggerFactory.getLogger(GridMailbox.class);
    private final Mailbox local;
    private final Id localId;
    private final Address address;
    private final HashRing<Id> hashRing;
    private final GridActorControl.Outbound outbound;
    private static final Set<Class<?>> overrides = new HashSet<Class<?>>(){
        {
            this.add(Stoppable.class);
        }
    };

    public GridMailbox(Mailbox local, Id localId, Address address, HashRing<Id> hashRing, GridActorControl.Outbound outbound) {
        this.local = local;
        this.localId = localId;
        this.address = address;
        this.hashRing = hashRing;
        this.outbound = outbound;
    }

    private void delegateUnlessIsRemote(Consumer<Id> remote, Runnable consumer) {
        if (!this.address.isDistributable()) {
            consumer.run();
            return;
        }
        Id nodeOf = this.hashRing.nodeOf(this.address.idString());
        if (nodeOf == null || nodeOf.equals((Object)this.localId)) {
            consumer.run();
        } else {
            remote.accept(nodeOf);
        }
    }

    private <R> R delegateUnlessIsRemote(Function<Id, R> remote, Supplier<R> supplier) {
        if (!this.address.isDistributable()) {
            return supplier.get();
        }
        Id nodeOf = this.hashRing.nodeOf(this.address.idString());
        if (nodeOf == null || nodeOf.equals((Object)this.localId)) {
            return supplier.get();
        }
        return remote.apply(nodeOf);
    }

    public void close() {
        this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::close on: " + nodeOf);
            this.local.close();
        }, () -> ((Mailbox)this.local).close());
    }

    public boolean isClosed() {
        return this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::isClosed on: " + nodeOf);
            return this.local.isClosed();
        }, () -> ((Mailbox)this.local).isClosed());
    }

    public boolean isDelivering() {
        return this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::isDelivering on: " + nodeOf);
            return this.local.isDelivering();
        }, () -> ((Mailbox)this.local).isDelivering());
    }

    public int concurrencyCapacity() {
        return this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::concurrencyCapacity on: " + nodeOf);
            return this.local.concurrencyCapacity();
        }, () -> ((Mailbox)this.local).concurrencyCapacity());
    }

    public void resume(String name) {
        this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::resume on: " + nodeOf);
            this.local.resume(name);
        }, () -> this.local.resume(name));
    }

    public void send(Message message) {
        this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::send(Message) on: " + nodeOf);
            LocalMessage localMessage = (LocalMessage)message;
            if (overrides.contains(localMessage.protocol())) {
                this.local.send(message);
            }
            this.outbound.deliver((Id)nodeOf, this.localId, (Returns<?>)localMessage.returns(), message.protocol(), this.address, Definition.SerializationProxy.from((Definition)message.actor().definition()), localMessage.consumer(), message.representation());
        }, () -> this.local.send(message));
    }

    public void send(Actor actor, Class<?> protocol, SerializableConsumer<?> consumer, Returns<?> returns, String representation) {
        this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::send(Actor, ...) on: " + nodeOf);
            if (overrides.contains(protocol)) {
                this.local.send(actor, protocol, consumer, returns, representation);
            }
            this.outbound.deliver((Id)nodeOf, this.localId, returns, protocol, this.address, Definition.SerializationProxy.from((Definition)actor.definition()), consumer, representation);
        }, () -> this.local.send(actor, protocol, consumer, returns, representation));
    }

    public boolean isPreallocated() {
        return this.local.isPreallocated();
    }

    public void suspendExceptFor(String name, Class<?> ... overrides) {
        this.local.suspendExceptFor(name, (Class[])overrides);
    }

    public boolean isSuspended() {
        return this.delegateUnlessIsRemote((Id nodeOf) -> false, () -> ((Mailbox)this.local).isSuspended());
    }

    public boolean isSuspendedFor(String name) {
        return this.local.isSuspendedFor(name);
    }

    public Message receive() {
        return this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::receive on: " + nodeOf);
            return this.local.receive();
        }, () -> ((Mailbox)this.local).receive());
    }

    public int pendingMessages() {
        return this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::pendingMessages on: " + nodeOf);
            return this.local.pendingMessages();
        }, () -> ((Mailbox)this.local).pendingMessages());
    }

    public void run() {
        this.delegateUnlessIsRemote((Id nodeOf) -> {
            log.debug("Remote::run on: " + nodeOf);
            this.local.run();
        }, (Runnable)this.local);
    }
}

