/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.ActorProxyBase;
import io.vlingo.actors.Address;
import io.vlingo.actors.Definition;
import io.vlingo.actors.GridActorOperations;
import io.vlingo.actors.GridRuntime;
import io.vlingo.actors.LocalMessage;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.Message;
import io.vlingo.actors.Returns;
import io.vlingo.actors.Stage;
import io.vlingo.common.SerializableConsumer;
import io.vlingo.lattice.grid.application.GridActorControl;
import io.vlingo.lattice.grid.application.message.Answer;
import io.vlingo.wire.node.Id;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class InboundGridActorControl
extends Actor
implements GridActorControl.Inbound {
    private final GridRuntime gridRuntime;
    private final Function<UUID, Returns<?>> correlation;

    public InboundGridActorControl(GridRuntime gridRuntime, Function<UUID, Returns<?>> correlation) {
        this.gridRuntime = gridRuntime;
        this.correlation = correlation;
    }

    @Override
    public <T> void answer(Id receiver, Id sender, Answer<T> answer) {
        this.logger().debug("GRID: Processing application message: Answer");
        Returns<?> clientReturns = this.correlation.apply(answer.correlationId);
        if (clientReturns == null) {
            this.logger().warn("GRID: Answer from {} for Returns with {} didn't match a Returns on this node!", new Object[]{sender, answer.correlationId});
            return;
        }
        if (answer.error == null) {
            Object result = ActorProxyBase.thunk((Stage)this.gridRuntime.asStage(), answer.result);
            if (clientReturns.isCompletes()) {
                clientReturns.asCompletes().with(result);
            } else if (clientReturns.isCompletableFuture()) {
                clientReturns.asCompletableFuture().complete(result);
            } else if (clientReturns.isFuture()) {
                ((CompletableFuture)clientReturns.asFuture()).complete(result);
            }
        } else if (clientReturns.isCompletes()) {
            clientReturns.asCompletes().failed((Exception)new RuntimeException("Remote actor call failed", answer.error));
        } else if (clientReturns.isCompletableFuture()) {
            clientReturns.asCompletableFuture().completeExceptionally(answer.error);
        } else if (clientReturns.isFuture()) {
            ((CompletableFuture)clientReturns.asFuture()).completeExceptionally(answer.error);
        }
    }

    @Override
    public void forward(Id receiver, Id sender, io.vlingo.lattice.grid.application.message.Message message) {
        throw new UnsupportedOperationException("Should have been handled in Visitor#accept(Id, Id, Forward) by dispatching the visitor to the enclosed Message");
    }

    @Override
    public <T> void start(Id receiver, Id sender, Class<T> protocol, Address address, Definition.SerializationProxy definition) {
        this.logger().debug("Processing: Received application message: Start");
        Stage stage = this.gridRuntime.asStage();
        Actor actor = stage.rawLookupOrStart(Definition.from((Stage)stage, (Definition.SerializationProxy)definition, (Logger)stage.world().defaultLogger()), address);
        if (GridActorOperations.isSuspendedForRelocation(actor)) {
            this.logger().debug("Resuming thunk found at {} with definition='{}'", new Object[]{address, actor.definition()});
            GridActorOperations.resumeFromRelocation(actor);
        }
    }

    @Override
    public <T> void deliver(Id receiver, Id sender, Returns<?> returns, Class<T> protocol, Address address, Definition.SerializationProxy definition, SerializableConsumer<T> consumer, String representation) {
        this.logger().debug("Processing: Received application message: Deliver");
        Stage stage = this.gridRuntime.asStage();
        Actor actor = stage.actorLookupOrStartThunk(Definition.from((Stage)stage, (Definition.SerializationProxy)definition, (Logger)stage.world().defaultLogger()), address);
        actor.lifeCycle.environment.mailbox.send(actor, protocol, consumer, returns, representation);
    }

    @Override
    public void relocate(Id receiver, Id sender, Definition.SerializationProxy definition, Address address, Object snapshot, List<? extends Message> pending) {
        this.logger().debug("Processing: Received application message: Relocate");
        Stage stage = this.gridRuntime.asStage();
        Actor actor = stage.actorLookupOrStartThunk(Definition.from((Stage)stage, (Definition.SerializationProxy)definition, (Logger)stage.world.defaultLogger()), address);
        GridActorOperations.applyRelocationSnapshot(stage, actor, snapshot);
        Mailbox mailbox = actor.lifeCycle.environment.mailbox;
        pending.forEach(pendingMessage -> {
            LocalMessage message = (LocalMessage)pendingMessage;
            message.set(actor, message.protocol(), message.consumer(), message.returns(), message.representation());
            mailbox.send((Message)message);
        });
        GridActorOperations.resumeFromRelocation(actor);
    }

    @Override
    public void disburse(Id id) {
        throw new UnsupportedOperationException("disburse of buffered messages handled in ApplicationMessageHandler");
    }

    public static class InboundGridActorControlInstantiator
    implements ActorInstantiator<InboundGridActorControl> {
        private static final long serialVersionUID = 1494058617174306163L;
        private final GridRuntime gridRuntime;
        private final Function<UUID, Returns<?>> correlation;

        public InboundGridActorControlInstantiator(GridRuntime gridRuntime, Function<UUID, Returns<?>> correlation) {
            this.gridRuntime = gridRuntime;
            this.correlation = correlation;
        }

        public InboundGridActorControl instantiate() {
            return new InboundGridActorControl(this.gridRuntime, this.correlation);
        }
    }
}

