/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.exchange;

public class ConnectionSettings {
    public static final int UndefinedPort = -1;
    public final String hostName;
    public final String password;
    public final int port;
    public final String username;
    public final String virtualHost;

    public static ConnectionSettings instance() {
        return new ConnectionSettings("localhost", -1, "/", null, null);
    }

    public static ConnectionSettings instance(String hostName, String virtualHost) {
        return new ConnectionSettings(hostName, -1, virtualHost, null, null);
    }

    public static ConnectionSettings instance(String hostName, int port, String virtualHost, String username, String password) {
        return new ConnectionSettings(hostName, port, virtualHost, username, password);
    }

    public ConnectionSettings(String hostName, int port, String virtualHost, String username, String password) {
        assert (hostName != null);
        this.hostName = hostName;
        assert (virtualHost != null);
        this.virtualHost = virtualHost;
        this.port = port;
        this.password = password;
        this.username = username;
    }

    public boolean hasPort() {
        return this.port > 0;
    }

    public boolean hasUserCredentials() {
        return this.username != null && this.password != null;
    }
}

