/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.exchange;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageParameters {
    private String applicationId;
    private String contentEncoding;
    private String contentType;
    private String correlationId;
    private String deliveryId;
    private DeliveryMode deliveryMode;
    private String exchangeName;
    private Map<String, Object> headers;
    private String messageId;
    private String other1;
    private String other2;
    private String other3;
    private Priority priority;
    private String queueName;
    private boolean redeliver;
    private String replyTo;
    private String returnAddress;
    private List<String> routing;
    private long timestamp;
    private long timeToLive;
    private String tag;
    private String typeCode;
    private String typeName;
    private String userId;

    public static MessageParameters bare() {
        return new MessageParameters();
    }

    public static MessageParameters withDefaults() {
        return new MessageParameters().contentEncoding(StandardCharsets.UTF_8.name()).contentType("text/plain").deliveryMode(DeliveryMode.Transient).headers(new HashMap<String, Object>(0)).priority(Priority.Normal).timestamp(System.currentTimeMillis()).timeToLive(Long.MAX_VALUE);
    }

    public MessageParameters applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public MessageParameters contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public MessageParameters contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public MessageParameters correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public MessageParameters deliveryId(String deliveryId) {
        this.deliveryId = deliveryId;
        return this;
    }

    public String deliveryId() {
        return this.deliveryId;
    }

    public MessageParameters deliveryMode(DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public DeliveryMode deliveryMode() {
        return this.deliveryMode;
    }

    public boolean isDurableDeliveryMode() {
        return this.deliveryMode != null && this.deliveryMode == DeliveryMode.Durable;
    }

    public boolean isTransientDeliveryMode() {
        return this.deliveryMode == null || this.deliveryMode == DeliveryMode.Transient;
    }

    public MessageParameters exchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
        return this;
    }

    public String exchangeName() {
        return this.exchangeName;
    }

    public MessageParameters headers(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public MessageParameters messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public String messageId() {
        return this.messageId;
    }

    public MessageParameters other1(String other1) {
        this.other1 = other1;
        return this;
    }

    public String other1() {
        return this.other1;
    }

    public MessageParameters other2(String other2) {
        this.other2 = other2;
        return this;
    }

    public String other2() {
        return this.other2;
    }

    public MessageParameters other3(String other3) {
        this.other3 = other3;
        return this;
    }

    public String other3() {
        return this.other3;
    }

    public MessageParameters priority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public Priority priority() {
        return this.priority;
    }

    public MessageParameters queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public String queueName() {
        return this.queueName;
    }

    public MessageParameters redeliver(boolean redeliver) {
        this.redeliver = redeliver;
        return this;
    }

    public boolean redeliver() {
        return this.redeliver;
    }

    public MessageParameters replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public String replyTo() {
        return this.replyTo;
    }

    public MessageParameters returnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
        return this;
    }

    public String returnAddress() {
        return this.returnAddress;
    }

    public MessageParameters routing(String ... routings) {
        this.routing = Arrays.asList(routings);
        return this;
    }

    public MessageParameters routing(List<String> routings) {
        this.routing = routings;
        return this;
    }

    public List<String> routing() {
        return this.routing;
    }

    public MessageParameters tag(String tag) {
        this.tag = tag;
        return this;
    }

    public String tag() {
        return this.tag;
    }

    public MessageParameters timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public MessageParameters timeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public long timeToLive() {
        return this.timeToLive;
    }

    public MessageParameters typeCode(String typeCode) {
        this.typeCode = typeCode;
        return this;
    }

    public String typeCode() {
        return this.typeCode;
    }

    public MessageParameters typeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String typeName() {
        return this.typeName;
    }

    public MessageParameters userId(String userId) {
        this.userId = userId;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public static enum Priority {
        High,
        Normal,
        Medium,
        Low,
        P0,
        P1,
        P2,
        P3,
        P4,
        P5,
        P6,
        P7,
        P8,
        P9;

    }

    public static enum DeliveryMode {
        Durable,
        Transient;

    }
}

