/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.exchange.feed;

import io.vlingo.lattice.exchange.feed.FeedItemId;
import io.vlingo.lattice.exchange.feed.FeedMessage;
import java.util.Collections;
import java.util.List;

public final class FeedItem {
    public final boolean archived;
    public final FeedItemId id;
    public final FeedItemId nextId;
    public final FeedItemId previousId;
    public final List<FeedMessage> messages;

    public static FeedItem archivedFeedItemWith(FeedItemId id, FeedItemId nextId, FeedItemId previousId, List<FeedMessage> messages) {
        return new FeedItem(id, nextId, previousId, messages, true);
    }

    public static FeedItem currentFeedWith(FeedItemId id, FeedItemId previousId, List<FeedMessage> messages) {
        return new FeedItem(id, previousId, messages);
    }

    private FeedItem(FeedItemId id, FeedItemId nextId, FeedItemId previousId, List<FeedMessage> messages, boolean archived) {
        assert (id != null);
        this.id = id;
        assert (nextId != null);
        this.nextId = nextId;
        assert (previousId != null);
        this.previousId = previousId;
        assert (messages != null);
        this.messages = Collections.unmodifiableList(messages);
        this.archived = archived;
    }

    private FeedItem(FeedItemId id, FeedItemId previousFeedId, List<FeedMessage> messages) {
        this(id, FeedItemId.Unknown, previousFeedId, messages, false);
    }
}

