/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.exchange.feed;

public final class FeedItemId {
    public static final FeedItemId Unknown = new FeedItemId("");
    public final String value;

    public static FeedItemId with(long id) {
        return new FeedItemId(id);
    }

    public FeedItemId(long id) {
        this.value = String.valueOf(id);
    }

    public FeedItemId(String id) {
        assert (id != null);
        this.value = id;
    }

    public FeedItemId copy() {
        return new FeedItemId(this.value);
    }

    public long toLong() {
        return Long.parseLong(this.value);
    }

    public FeedItemId next() {
        return new FeedItemId(this.toLong() + 1L);
    }

    public boolean hasPrevious() {
        return this.toLong() > 0L;
    }

    public FeedItemId previous() {
        long id = this.toLong();
        if (id == 0L) {
            throw new IllegalStateException("No previous identity.");
        }
        return new FeedItemId(id - 1L);
    }

    public boolean isUnknown() {
        return this.equals(Unknown);
    }

    public int hashCode() {
        return 31 * this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != FeedItemId.class) {
            return false;
        }
        return this.value.equals(((FeedItemId)other).value);
    }

    public String toString() {
        return "FeedItemId[value=" + this.value + "]";
    }
}

