/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.exchange.feed;

import io.vlingo.actors.Actor;
import io.vlingo.lattice.exchange.feed.Feed;
import io.vlingo.lattice.exchange.feed.FeedConsumer;
import io.vlingo.lattice.exchange.feed.FeedItem;
import io.vlingo.lattice.exchange.feed.FeedItemId;
import io.vlingo.lattice.exchange.feed.FeedMessage;
import io.vlingo.lattice.exchange.feed.FeedMessageBody;
import io.vlingo.lattice.exchange.feed.Feeder;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.store.EntryReader;
import java.util.ArrayList;
import java.util.List;

public class TextEntryReaderFeeder
extends Actor
implements Feeder {
    private final EntryReader<BaseEntry.TextEntry> entryReader;
    private final Feed feed;

    public TextEntryReaderFeeder(Feed feed, EntryReader<BaseEntry.TextEntry> entryReader) {
        this.feed = feed;
        this.entryReader = entryReader;
    }

    @Override
    public void feedItemTo(FeedItemId feedItemId, FeedConsumer feedInterest) {
        long feedId = feedItemId.toLong();
        long id = (feedId - 1L) * (long)this.feed.messagesPerFeedItem() + 1L;
        this.entryReader.readNext(String.valueOf(id), this.feed.messagesPerFeedItem()).andThen(entries -> {
            feedInterest.consumeFeedItem(this.toFeedItem(feedItemId, (List<BaseEntry.TextEntry>)entries));
            return entries;
        });
    }

    private FeedItem toFeedItem(FeedItemId feedItemId, List<BaseEntry.TextEntry> entries) {
        ArrayList<FeedMessage> messages = new ArrayList<FeedMessage>(entries.size());
        for (BaseEntry.TextEntry entry : entries) {
            FeedMessageBody body = FeedMessageBody.with((String)entry.entryData());
            FeedMessage message = FeedMessage.with(entry.id(), body, entry.typeName(), entry.typeVersion());
            messages.add(message);
        }
        if (this.feed.messagesPerFeedItem() == entries.size()) {
            return FeedItem.archivedFeedItemWith(feedItemId, feedItemId.next(), feedItemId.previous(), messages);
        }
        return FeedItem.currentFeedWith(feedItemId, feedItemId.previous(), messages);
    }
}

