/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.GridRuntime;
import io.vlingo.actors.InboundGridActorControl;
import io.vlingo.actors.Returns;
import io.vlingo.cluster.model.application.ClusterApplicationAdapter;
import io.vlingo.cluster.model.attribute.Attribute;
import io.vlingo.cluster.model.attribute.AttributesProtocol;
import io.vlingo.lattice.grid.application.ApplicationMessageHandler;
import io.vlingo.lattice.grid.application.GridActorControl;
import io.vlingo.lattice.grid.application.GridApplicationMessageHandler;
import io.vlingo.lattice.grid.application.OutboundGridActorControl;
import io.vlingo.lattice.grid.application.QuorumObserver;
import io.vlingo.lattice.grid.application.message.serialization.FSTDecoder;
import io.vlingo.lattice.grid.application.message.serialization.FSTEncoder;
import io.vlingo.lattice.util.ExpiringHardRefHolder;
import io.vlingo.lattice.util.HardRefHolder;
import io.vlingo.lattice.util.OutBuffers;
import io.vlingo.wire.fdx.outbound.ApplicationOutboundStream;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.nustaq.serialization.FSTConfiguration;

public class GridNode
extends ClusterApplicationAdapter {
    private static final Map<UUID, Returns<?>> correlation = new HashMap();
    private AttributesProtocol client;
    private final GridRuntime gridRuntime;
    private final Node localNode;
    private final GridActorControl.Outbound outbound;
    private final ApplicationMessageHandler applicationMessageHandler;
    private final Collection<QuorumObserver> quorumObservers;

    public GridNode(GridRuntime gridRuntime, Node localNode) {
        this.gridRuntime = gridRuntime;
        this.localNode = localNode;
        FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
        conf.setClassLoader(gridRuntime.worldClassLoader());
        HardRefHolder holder = (HardRefHolder)gridRuntime.world().actorFor(HardRefHolder.class, Definition.has(ExpiringHardRefHolder.class, ExpiringHardRefHolder::new));
        this.outbound = (GridActorControl.Outbound)this.stage().actorFor(GridActorControl.Outbound.class, OutboundGridActorControl.class, (ActorInstantiator)new OutboundGridActorControl.OutboundGridActorControlInstantiator(localNode.id(), new FSTEncoder(conf), correlation::put, new OutBuffers(holder)));
        this.gridRuntime.setOutbound(this.outbound);
        GridActorControl.Inbound inbound = (GridActorControl.Inbound)this.stage().actorFor(GridActorControl.Inbound.class, InboundGridActorControl.class, (ActorInstantiator)new InboundGridActorControl.InboundGridActorControlInstantiator(gridRuntime, correlation::remove));
        this.applicationMessageHandler = new GridApplicationMessageHandler(localNode.id(), gridRuntime.hashRing(), inbound, this.outbound, new FSTDecoder(conf), holder, this.scheduler());
        this.quorumObservers = new ArrayList<QuorumObserver>(3);
        this.registerQuorumObserver(gridRuntime);
    }

    public final void registerQuorumObserver(QuorumObserver observer) {
        this.quorumObservers.add(observer);
    }

    public void start() {
        this.logger().debug("GRID: Started on node: " + this.localNode);
        this.gridRuntime.hashRing().includeNode(this.localNode.id());
    }

    public void handleApplicationMessage(RawMessage message) {
        this.logger().debug("GRID: Received application message: " + message.asTextMessage());
        this.applicationMessageHandler.handle(message);
    }

    public void informResponder(ApplicationOutboundStream responder) {
        this.outbound.useStream(responder);
    }

    public void informAllLiveNodes(Collection<Node> liveNodes, boolean isHealthyCluster) {
        this.logger().debug("GRID: Live nodes confirmed: " + liveNodes + " and is healthy: " + isHealthyCluster);
    }

    public void informLeaderElected(Id leaderId, boolean isHealthyCluster, boolean isLocalNodeLeading) {
        this.logger().debug("GRID: Leader elected: " + leaderId + " and is healthy: " + isHealthyCluster);
        if (isLocalNodeLeading) {
            this.logger().debug("GRID: Local node is leading.");
        }
    }

    public void informLeaderLost(Id lostLeaderId, boolean isHealthyCluster) {
        this.logger().debug("GRID: Leader lost: " + lostLeaderId + " and is healthy: " + isHealthyCluster);
    }

    public void informLocalNodeShutDown(Id nodeId) {
        this.logger().debug("GRID: Local node shut down: " + nodeId);
    }

    public void informLocalNodeStarted(Id nodeId) {
        this.logger().debug("GRID: Local node started: " + nodeId);
    }

    public void informNodeIsHealthy(Id nodeId, boolean isHealthyCluster) {
        this.logger().debug("GRID: Node reported healthy: " + nodeId + " and is healthy: " + isHealthyCluster);
        if (isHealthyCluster) {
            this.outbound.disburse(nodeId);
            this.applicationMessageHandler.disburse(nodeId);
        }
    }

    public void informNodeJoinedCluster(Id nodeId, boolean isHealthyCluster) {
        this.logger().debug("GRID: Node joined: " + nodeId + " and is healthy: " + isHealthyCluster);
        this.gridRuntime.nodeJoined(nodeId);
    }

    public void informNodeLeftCluster(Id nodeId, boolean isHealthyCluster) {
        this.logger().debug("GRID: Node left: " + nodeId + " and is healthy: " + isHealthyCluster);
        this.gridRuntime.hashRing().excludeNode(nodeId);
    }

    public void informQuorumAchieved() {
        this.logger().debug("GRID: Quorum achieved");
        this.quorumObservers.forEach(QuorumObserver::quorumAchieved);
    }

    public void informQuorumLost() {
        this.logger().debug("GRID: Quorum lost");
        this.quorumObservers.forEach(QuorumObserver::quorumLost);
    }

    public void informAttributesClient(AttributesProtocol client) {
        this.logger().debug("GRID: Attributes Client received.");
        this.client = client;
    }

    public void informAttributeSetCreated(String attributeSetName) {
        this.logger().debug("GRID: Attributes Set Created: " + attributeSetName);
    }

    public void informAttributeAdded(String attributeSetName, String attributeName) {
        Attribute attr = this.client.attribute(attributeSetName, attributeName);
        this.logger().debug("GRID: Attribute Set " + attributeSetName + " Attribute Added: " + attributeName + " Value: " + (String)attr.value);
    }

    public void informAttributeRemoved(String attributeSetName, String attributeName) {
        Attribute attr = this.client.attribute(attributeSetName, attributeName);
        this.logger().debug("GRID: Attribute Set " + attributeSetName + " Attribute Removed: " + attributeName + " Attribute: " + attr);
    }

    public void informAttributeSetRemoved(String attributeSetName) {
        this.logger().debug("GRID: Attributes Set Removed: " + attributeSetName);
    }

    public void informAttributeReplaced(String attributeSetName, String attributeName) {
        Attribute attr = this.client.attribute(attributeSetName, attributeName);
        this.logger().debug("GRID: Attribute Set " + attributeSetName + " Attribute Replaced: " + attributeName + " Value: " + (String)attr.value);
    }
}

