/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid;

import io.vlingo.actors.GridRuntime;
import io.vlingo.actors.Logger;
import io.vlingo.actors.World;
import io.vlingo.cluster.model.Cluster;
import io.vlingo.cluster.model.ClusterSnapshotControl;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.common.Tuple2;
import io.vlingo.lattice.grid.GridNode;
import io.vlingo.lattice.grid.GridShutdownHook;

public class GridNodeBootstrap {
    private final Tuple2<ClusterSnapshotControl, Logger> clusterSnapshotControl;
    private final GridShutdownHook shutdownHook;

    public static GridNodeBootstrap boot(GridRuntime grid, String nodeName, boolean embedded) throws Exception {
        return GridNodeBootstrap.boot(grid, nodeName, Properties.instance, embedded);
    }

    public static GridNodeBootstrap boot(GridRuntime grid, String nodeName, Properties properties, boolean embedded) throws Exception {
        properties.validateRequired(nodeName);
        Tuple2 control = Cluster.controlFor((World)grid.world(), (ClusterApplication.ClusterApplicationInstantiator)new GridNodeInstantiator(grid), (Properties)properties, (String)nodeName);
        GridNodeBootstrap instance = new GridNodeBootstrap((Tuple2<ClusterSnapshotControl, Logger>)control, nodeName);
        ((Logger)control._2).info("Successfully started cluster node: '" + nodeName + "'");
        if (!embedded) {
            ((Logger)control._2).info("==========");
        }
        return instance;
    }

    public ClusterSnapshotControl clusterSnapshotControl() {
        return (ClusterSnapshotControl)this.clusterSnapshotControl._1;
    }

    private GridNodeBootstrap(Tuple2<ClusterSnapshotControl, Logger> control, String nodeName) throws Exception {
        this.clusterSnapshotControl = control;
        this.shutdownHook = new GridShutdownHook(nodeName, control);
        this.shutdownHook.register();
    }

    private static class GridNodeInstantiator
    extends ClusterApplication.ClusterApplicationInstantiator<GridNode> {
        private static final long serialVersionUID = -7096922857258549619L;
        private final GridRuntime gridRuntime;

        public GridNodeInstantiator(GridRuntime gridRuntime) {
            super(GridNode.class);
            this.gridRuntime = gridRuntime;
        }

        public GridNode instantiate() {
            this.gridRuntime.setNodeId(this.node().id());
            return new GridNode(this.gridRuntime, this.node());
        }
    }
}

