/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.hashring;

import io.vlingo.lattice.grid.hashring.HashRing;
import io.vlingo.lattice.grid.hashring.HashedIdentity;
import io.vlingo.lattice.grid.hashring.HashedNodePoint;
import io.vlingo.lattice.grid.hashring.MD5HashRing;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.BiFunction;

public class MD5ArrayHashRing<T>
extends MD5HashRing<T>
implements HashRing<T> {
    private HashedNodePoint<T>[] hashedNodePoints = new HashedNodePoint[0];

    public MD5ArrayHashRing(int pointsPerNode, BiFunction<Integer, T, HashedNodePoint<T>> factory) throws Exception {
        super(pointsPerNode, factory);
    }

    @Override
    public void dump() {
        System.out.println("NODES: " + this.hashedNodePoints.length);
        for (HashedNodePoint<T> hashedNodePoint : this.hashedNodePoints) {
            System.out.println("NODE: " + hashedNodePoint);
        }
    }

    @Override
    public HashRing<T> excludeNode(T nodeIdentifier) {
        HashedNodePoint<T>[] exclusive = this.less();
        int index = 0;
        int element = 0;
        int hash = this.hashed(nodeIdentifier.toString() + element);
        for (HashedNodePoint<T> hashedNodePoint : this.hashedNodePoints) {
            if (hashedNodePoint.hash() == hash) {
                hash = this.hashed(nodeIdentifier.toString() + ++element);
                continue;
            }
            exclusive[index++] = hashedNodePoint;
        }
        this.hashedNodePoints = exclusive;
        return this;
    }

    @Override
    public HashRing<T> includeNode(T nodeIdentifier) {
        int startingAt;
        for (int element = startingAt = this.moreStartingAt(); element < this.hashedNodePoints.length; ++element) {
            int hash = this.hashed(nodeIdentifier.toString() + element);
            this.hashedNodePoints[element] = (HashedNodePoint)this.factory.apply(hash, nodeIdentifier);
        }
        Arrays.sort(this.hashedNodePoints, Comparator.comparingInt(HashedIdentity::hash));
        return this;
    }

    @Override
    public T nodeOf(Object id) {
        HashedNodePoint hashedNodePoint = this.hashedNodePointOf(id);
        int index = Arrays.binarySearch(this.hashedNodePoints, hashedNodePoint, Comparator.comparingInt(HashedIdentity::hash));
        if (index < 0 && (index = -index) >= this.hashedNodePoints.length) {
            index = 0;
        }
        return this.hashedNodePoints[index].nodeIdentifier;
    }

    private HashedNodePoint<T>[] less() {
        HashedNodePoint[] less = new HashedNodePoint[this.hashedNodePoints.length - this.pointsPerNode];
        return less;
    }

    private int moreStartingAt() {
        HashedNodePoint<T>[] previous = this.hashedNodePoints;
        this.hashedNodePoints = new HashedNodePoint[previous.length + this.pointsPerNode];
        System.arraycopy(previous, 0, this.hashedNodePoints, 0, previous.length);
        return previous.length;
    }
}

