/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.hashring;

import io.vlingo.lattice.grid.hashring.HashRing;
import io.vlingo.lattice.grid.hashring.HashedNodePoint;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.function.BiFunction;

public abstract class MD5HashRing<T>
implements HashRing<T> {
    protected final BiFunction<Integer, T, HashedNodePoint<T>> factory;
    protected final MessageDigest hasher;
    protected final int pointsPerNode;

    protected MD5HashRing(int pointsPerNode, BiFunction<Integer, T, HashedNodePoint<T>> factory) throws Exception {
        this.pointsPerNode = pointsPerNode;
        this.factory = factory;
        this.hasher = MessageDigest.getInstance("MD5");
    }

    protected int hashed(Object id) {
        this.hasher.reset();
        this.hasher.update(StandardCharsets.UTF_8.encode(id.toString()));
        int hash = Arrays.hashCode(this.hasher.digest());
        return hash;
    }

    protected HashedNodePoint<T> hashedNodePointOf(Object id) {
        HashedNodePoint<T> hashedNodePointOf = this.factory.apply(this.hashed(id), null);
        return hashedNodePointOf;
    }
}

