/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.hashring;

import io.vlingo.lattice.grid.hashring.HashRing;
import io.vlingo.lattice.grid.hashring.HashedIdentity;
import io.vlingo.lattice.grid.hashring.HashedNodePoint;
import io.vlingo.lattice.grid.hashring.MD5HashRing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiFunction;

public class MD5ListHashRing<T>
extends MD5HashRing<T> {
    private final List<HashedNodePoint<T>> hashedNodePoints = new ArrayList<HashedNodePoint<T>>();

    public MD5ListHashRing(int pointsPerNode, BiFunction<Integer, T, HashedNodePoint<T>> factory) throws Exception {
        super(pointsPerNode, factory);
    }

    @Override
    public void dump() {
        System.out.println("NODES: " + this.hashedNodePoints.size());
        for (HashedNodePoint<T> hashedNodePoint : this.hashedNodePoints) {
            System.out.println("NODE: " + hashedNodePoint);
        }
    }

    @Override
    public HashRing<T> excludeNode(T nodeIdentifier) {
        ListIterator<HashedNodePoint<T>> iterator = this.hashedNodePoints.listIterator();
        int element = 0;
        int hash = this.hashed(nodeIdentifier.toString() + element);
        while (iterator.hasNext()) {
            HashedNodePoint<T> hashedNodePoint = iterator.next();
            if (hashedNodePoint.hash() == hash) {
                hash = this.hashed(nodeIdentifier.toString() + ++element);
                continue;
            }
            iterator.remove();
            hashedNodePoint.excluded();
        }
        return this;
    }

    @Override
    public HashRing<T> includeNode(T nodeIdentifier) {
        for (int element = 0; element < this.pointsPerNode; ++element) {
            this.hasher.reset();
            this.hasher.update(StandardCharsets.UTF_8.encode(nodeIdentifier.toString() + element));
            int hash = Arrays.hashCode(this.hasher.digest());
            HashedNodePoint hashedNodePoint = (HashedNodePoint)this.factory.apply(hash, nodeIdentifier);
            this.hashedNodePoints.add(hashedNodePoint);
            hashedNodePoint.included();
        }
        Collections.sort(this.hashedNodePoints, Comparator.comparingInt(HashedIdentity::hash));
        return this;
    }

    @Override
    public T nodeOf(Object id) {
        HashedNodePoint hashedNodePoint = this.hashedNodePointOf(id);
        int index = Collections.binarySearch(this.hashedNodePoints, hashedNodePoint, Comparator.comparingInt(HashedIdentity::hash));
        if (index < 0 && (index = -index) >= this.hashedNodePoints.size()) {
            index = 0;
        }
        return this.hashedNodePoints.get((int)index).nodeIdentifier;
    }
}

