/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.hashring;

import io.vlingo.lattice.grid.hashring.HashRing;
import io.vlingo.lattice.grid.hashring.HashedIdentity;
import io.vlingo.lattice.grid.hashring.HashedNodePoint;
import io.vlingo.lattice.grid.hashring.MurmurHash;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.BiFunction;

public class MurmurArrayHashRing<T>
implements HashRing<T> {
    private static final int DefaultSeed = 31;
    private final ByteBuffer buffer;
    private final BiFunction<Integer, T, HashedNodePoint<T>> factory;
    private HashedNodePoint<T>[] hashedNodePoints;
    private final int pointsPerNode;
    private final int seed;

    public MurmurArrayHashRing(int pointsPerNode, BiFunction<Integer, T, HashedNodePoint<T>> factory) {
        this(pointsPerNode, factory, 31);
    }

    public MurmurArrayHashRing(int pointsPerNode, BiFunction<Integer, T, HashedNodePoint<T>> factory, int seed) {
        this.pointsPerNode = pointsPerNode;
        this.factory = factory;
        this.seed = seed;
        this.buffer = ByteBuffer.allocate(64);
        this.hashedNodePoints = new HashedNodePoint[0];
    }

    @Override
    public void dump() {
        System.out.println("NODES: " + this.hashedNodePoints.length);
        for (HashedNodePoint<T> hashedNodePoint : this.hashedNodePoints) {
            System.out.println("NODE: " + hashedNodePoint);
        }
    }

    @Override
    public HashRing<T> excludeNode(T nodeIdentifier) {
        HashedNodePoint<T>[] exclusive = this.less();
        int index = 0;
        int element = 0;
        int hash = this.hashed(nodeIdentifier.toString() + element);
        for (HashedNodePoint<T> hashedNodePoint : this.hashedNodePoints) {
            if (hashedNodePoint.hash() == hash) {
                hashedNodePoint.excluded();
                hash = this.hashed(nodeIdentifier.toString() + ++element);
                continue;
            }
            exclusive[index++] = hashedNodePoint;
        }
        this.hashedNodePoints = exclusive;
        return this;
    }

    @Override
    public HashRing<T> includeNode(T nodeIdentifier) {
        int startingAt;
        for (int element = startingAt = this.moreStartingAt(); element < this.hashedNodePoints.length; ++element) {
            int hash = this.hashed(nodeIdentifier.toString() + element);
            HashedNodePoint<T> hashedNodePoint = this.factory.apply(hash, (Integer)nodeIdentifier);
            this.hashedNodePoints[element] = hashedNodePoint;
            hashedNodePoint.included();
        }
        Arrays.sort(this.hashedNodePoints, Comparator.comparingInt(HashedIdentity::hash));
        return this;
    }

    @Override
    public T nodeOf(Object id) {
        if (this.hashedNodePoints.length == 0) {
            return null;
        }
        HashedNodePoint<T> hashedNodePoint = this.hashedNodePointOf(id);
        int index = Arrays.binarySearch(this.hashedNodePoints, hashedNodePoint, Comparator.comparingInt(HashedIdentity::hash));
        if (index < 0 && (index = -index) >= this.hashedNodePoints.length) {
            index = 0;
        }
        return this.hashedNodePoints[index].nodeIdentifier;
    }

    private int hashed(Object id) {
        this.buffer.clear();
        this.buffer.put(id.toString().getBytes());
        return MurmurHash.hash32(this.buffer, 0, this.buffer.position(), this.seed);
    }

    private HashedNodePoint<T> hashedNodePointOf(Object id) {
        HashedNodePoint<T> hashedNodePoint = this.factory.apply(this.hashed(id), null);
        return hashedNodePoint;
    }

    private HashedNodePoint<T>[] less() {
        HashedNodePoint[] less = new HashedNodePoint[this.hashedNodePoints.length - this.pointsPerNode];
        return less;
    }

    private int moreStartingAt() {
        HashedNodePoint<T>[] previous = this.hashedNodePoints;
        this.hashedNodePoints = new HashedNodePoint[previous.length + this.pointsPerNode];
        System.arraycopy(previous, 0, this.hashedNodePoints, 0, previous.length);
        return previous.length;
    }
}

