/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.hashring;

import io.vlingo.common.pool.ElasticResourcePool;
import io.vlingo.common.pool.ResourceFactory;
import io.vlingo.common.pool.ResourcePool;
import io.vlingo.lattice.grid.hashring.HashRing;
import io.vlingo.lattice.grid.hashring.MurmurHash;
import java.nio.ByteBuffer;
import java.util.SortedMap;
import java.util.TreeMap;

public class MurmurSortedMapHashRing<T>
implements HashRing<T> {
    private static final int DefaultSeed = 31;
    private final int pointsPerNode;
    private final int seed;
    private final ResourcePool<ByteBuffer, Void> byteBufferPool = new ElasticResourcePool(ElasticResourcePool.Config.of((int)10), (ResourceFactory)new ResourceFactory<ByteBuffer, Void>(){

        public Class<ByteBuffer> type() {
            return ByteBuffer.class;
        }

        public ByteBuffer create(Void aVoid) {
            return ByteBuffer.allocate(36);
        }

        public Void defaultArguments() {
            return null;
        }

        public ByteBuffer reset(ByteBuffer byteBuffer, Void aVoid) {
            byteBuffer.clear();
            return byteBuffer;
        }

        public void destroy(ByteBuffer byteBuffer) {
        }
    });
    private final SortedMap<Integer, T> ring;

    public MurmurSortedMapHashRing(int pointsPerNode) {
        this(pointsPerNode, 31);
    }

    public MurmurSortedMapHashRing(int pointsPerNode, int seed) {
        this.pointsPerNode = pointsPerNode;
        this.seed = seed;
        this.ring = new TreeMap<Integer, T>();
    }

    private MurmurSortedMapHashRing(int pointsPerNode, int seed, SortedMap<Integer, T> ring) {
        this.pointsPerNode = pointsPerNode;
        this.seed = seed;
        this.ring = ring;
    }

    @Override
    public void dump() {
        System.out.println("NODES: " + this.ring.size());
        for (T hashedNodePoint : this.ring.values()) {
            System.out.println("NODE: " + hashedNodePoint);
        }
    }

    @Override
    public HashRing<T> includeNode(T nodeIdentifier) {
        for (int i = 0; i < this.pointsPerNode; ++i) {
            int hash = this.hashed(nodeIdentifier.toString() + i);
            this.ring.put(hash, nodeIdentifier);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int hashed(Object id) {
        int hash;
        ByteBuffer buffer = (ByteBuffer)this.byteBufferPool.acquire();
        try {
            buffer.put(id.toString().getBytes());
            hash = MurmurHash.hash32(buffer, 0, buffer.position(), this.seed);
        }
        finally {
            this.byteBufferPool.release((Object)buffer);
        }
        return hash;
    }

    @Override
    public HashRing<T> excludeNode(T nodeIdentifier) {
        for (int i = 0; i < this.pointsPerNode; ++i) {
            int hash = this.hashed(nodeIdentifier.toString() + i);
            this.ring.remove(hash);
        }
        return this;
    }

    @Override
    public T nodeOf(Object id) {
        if (this.ring.isEmpty()) {
            return null;
        }
        int hash = this.hashed(id);
        if (!this.ring.containsKey(hash)) {
            SortedMap<Integer, T> tailMap = this.ring.tailMap(hash);
            hash = tailMap.isEmpty() ? this.ring.firstKey().intValue() : tailMap.firstKey().intValue();
        }
        return (T)this.ring.get(hash);
    }

    @Override
    public HashRing<T> copy() {
        TreeMap _ring = (TreeMap)this.ring;
        return new MurmurSortedMapHashRing<T>(this.pointsPerNode, this.seed, (TreeMap)_ring.clone());
    }
}

