/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.spaces;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Grid;
import io.vlingo.lattice.grid.spaces.PartitioningSpaceRouter;
import io.vlingo.lattice.grid.spaces.Space;
import io.vlingo.lattice.grid.spaces.SpaceItemFactoryRelay;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Accessor {
    private static final long DefaultScanInterval = 15000L;
    private static final int DefaultTotalPartitions = 5;
    private static final Accessor NullAccessor = new Accessor(null, null);
    public final String name;
    private final Grid grid;
    private final Map<String, Space> spaces = new ConcurrentHashMap<String, Space>();

    public static Accessor named(Grid grid, String name) {
        Accessor accessor = (Accessor)grid.world().resolveDynamic(name, Accessor.class);
        if (accessor == null) {
            accessor = NullAccessor;
        }
        return accessor;
    }

    public static synchronized Accessor using(Grid grid, String name) {
        Accessor accessor = (Accessor)grid.world().resolveDynamic(name, Accessor.class);
        if (accessor == null) {
            accessor = new Accessor(grid, name);
            grid.world().registerDynamic(name, (Object)accessor);
        }
        return accessor;
    }

    public boolean isDefined() {
        return this.grid != null && this.name != null;
    }

    public boolean isNotDefined() {
        return !this.isDefined();
    }

    public Space spaceFor(String name) {
        return this.spaceFor(name, 5, Duration.ofMillis(15000L));
    }

    public Space spaceFor(String name, int totalPartitions) {
        return this.spaceFor(name, totalPartitions, Duration.ofMillis(15000L));
    }

    public Space spaceFor(String name, long defaultScanInterval) {
        return this.spaceFor(name, 5, Duration.ofMillis(defaultScanInterval));
    }

    public Space spaceFor(String name, int totalPartitions, long defaultScanInterval) {
        return this.spaceFor(name, totalPartitions, Duration.ofMillis(defaultScanInterval));
    }

    public synchronized Space spaceFor(String name, int totalPartitions, Duration defaultScanInterval) {
        if (defaultScanInterval.isNegative() || defaultScanInterval.isZero()) {
            throw new IllegalArgumentException("The defaultScanInterval must be greater than zero.");
        }
        if (!this.isDefined()) {
            throw new IllegalStateException("Accessor is invalid.");
        }
        Space space = this.spaces.get(name);
        if (space == null) {
            Definition definition = Definition.has(PartitioningSpaceRouter.class, (ActorInstantiator)new Space.PartitioningSpaceRouterInstantiator(totalPartitions, defaultScanInterval), (String)name);
            Space internalSpace = (Space)this.grid.actorFor(Space.class, definition);
            space = new SpaceItemFactoryRelay(this.grid, internalSpace);
            this.spaces.put(name, space);
        }
        return space;
    }

    private Accessor(Grid grid, String name) {
        this.grid = grid;
        this.name = name;
    }
}

