/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.spaces;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.Definition;
import io.vlingo.common.Completes;
import io.vlingo.lattice.grid.spaces.Item;
import io.vlingo.lattice.grid.spaces.Key;
import io.vlingo.lattice.grid.spaces.KeyItem;
import io.vlingo.lattice.grid.spaces.Period;
import io.vlingo.lattice.grid.spaces.Space;
import io.vlingo.lattice.grid.spaces.SpaceActor;
import java.time.Duration;
import java.util.Optional;

public class PartitioningSpaceRouter
extends Actor
implements Space {
    private Space[] partitions;
    private final int totalPartitions;

    public PartitioningSpaceRouter(int totalPartitions, Duration defaultScanInterval) {
        this.totalPartitions = totalPartitions;
        this.partitions = new Space[totalPartitions];
        this.initialize(defaultScanInterval);
    }

    @Override
    public <T> Completes<T> itemFor(Class<T> protocol, Class<? extends Actor> type, Object ... parameters) {
        return this.completes().with(null);
    }

    @Override
    public <T> Completes<KeyItem<T>> put(Key key, Item<T> item) {
        CompletesEventually completes = this.completesEventually();
        this.spaceOf(key).put(key, item).andFinallyConsume(keyItem -> completes.with(keyItem));
        return this.completes();
    }

    @Override
    public <T> Completes<Optional<KeyItem<T>>> get(Key key, Period until) {
        CompletesEventually completes = this.completesEventually();
        this.spaceOf(key).get(key, until).andFinallyConsume(keyItem -> completes.with(keyItem));
        return this.completes();
    }

    @Override
    public <T> Completes<Optional<KeyItem<T>>> take(Key key, Period until) {
        CompletesEventually completes = this.completesEventually();
        this.spaceOf(key).take(key, until).andFinallyConsume(keyItem -> completes.with(keyItem));
        return this.completes();
    }

    private void initialize(Duration defaultScanInterval) {
        for (int count = 0; count < this.totalPartitions; ++count) {
            Space internalSpace;
            Definition definition = Definition.has(SpaceActor.class, (ActorInstantiator)new Space.SpaceInstantiator(defaultScanInterval), (String)(this.address().name() + "-" + count));
            this.partitions[count] = internalSpace = (Space)this.childActorFor(Space.class, definition);
        }
    }

    private Space spaceOf(Key key) {
        int partition = key.hashCode() % this.totalPartitions;
        return this.partitions[partition];
    }
}

