/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.spaces;

import java.time.Duration;
import java.time.Instant;

public class Period {
    public static final Period Forever = Period.of(Instant.MAX.getEpochSecond());
    public static final Period None = Period.of(0L);
    public final Duration duration;

    public static Period of(Duration duration) {
        return new Period(duration);
    }

    public static Period of(long duration) {
        return new Period(Duration.ofMillis(duration));
    }

    public boolean isForever() {
        return this.toMilliseconds() == Forever.toMilliseconds();
    }

    public Instant toFutureInstant() {
        return this.isForever() ? Instant.MAX : Instant.now().plus(this.duration);
    }

    public long toMilliseconds() {
        return this.duration.toMillis();
    }

    protected Period(Duration duration) {
        this.duration = duration;
    }
}

