/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.grid.spaces;

import io.vlingo.actors.Actor;
import io.vlingo.common.Cancellable;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduled;
import io.vlingo.lattice.grid.spaces.ExpirableItem;
import io.vlingo.lattice.grid.spaces.ExpirableQuery;
import io.vlingo.lattice.grid.spaces.Item;
import io.vlingo.lattice.grid.spaces.Key;
import io.vlingo.lattice.grid.spaces.KeyItem;
import io.vlingo.lattice.grid.spaces.Period;
import io.vlingo.lattice.grid.spaces.ScheduledScanner;
import io.vlingo.lattice.grid.spaces.Space;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class SpaceActor
extends Actor
implements Space,
Scheduled<ScheduledScanner<?>> {
    private static final long Brief = 5L;
    private static final long Rounding = 100L;
    private final Set<ExpirableItem<?>> expirableItems;
    private final Set<ExpirableQuery> expirableQueries;
    private final Duration defaultScanInterval;
    private final Map<Class<Key>, Map<Key, ExpirableItem<?>>> registry;
    private final ScheduledQueryRunnerEvictor scheduledQueryRunnerEvictor;
    private final ScheduledSweeper scheduledSweeper;
    private final Scheduled<ScheduledScanner<?>> scheduled;

    public SpaceActor(Duration defaultScanInterval) {
        this.defaultScanInterval = defaultScanInterval;
        this.expirableItems = new TreeSet();
        this.expirableQueries = new TreeSet<ExpirableQuery>();
        this.registry = new HashMap();
        this.scheduled = (Scheduled)this.selfAs(Scheduled.class);
        this.scheduledQueryRunnerEvictor = new ScheduledQueryRunnerEvictor();
        this.scheduledSweeper = new ScheduledSweeper();
    }

    @Override
    public <T> Completes<T> itemFor(Class<T> protocol, Class<? extends Actor> type, Object ... parameters) {
        return this.completes().with(null);
    }

    @Override
    public <T> Completes<KeyItem<T>> put(Key key, Item<T> item) {
        this.manage(key, item);
        return this.completes().with(KeyItem.of(key, item.object, item.lease));
    }

    @Override
    public <T> Completes<Optional<KeyItem<T>>> get(Key key, Period until) {
        ExpirableItem<T> item = this.item(key, true);
        if (item == null) {
            this.periodicQuery(key, true, until);
            return this.completes();
        }
        return this.completes().with(Optional.of(KeyItem.of(key, item.object, item.lease)));
    }

    @Override
    public <T> Completes<Optional<KeyItem<T>>> take(Key key, Period until) {
        ExpirableItem<T> item = this.item(key, false);
        if (item == null) {
            this.periodicQuery(key, false, until);
            return this.completes();
        }
        return this.completes().with(Optional.of(KeyItem.of(key, item.object, item.lease)));
    }

    public void intervalSignal(Scheduled<ScheduledScanner<?>> scheduled, ScheduledScanner<?> scanner) {
        scanner.scan();
    }

    private <T> ExpirableItem<T> expiringItem(Key key, Item<T> item) {
        Instant expiration = item.lease.toFutureInstant();
        return new ExpirableItem(key, item.object, expiration, item.lease);
    }

    private <T> ExpirableQuery expiringQuery(Key key, boolean retainItem, Period period) {
        Instant expiration = period.toFutureInstant();
        return new ExpirableQuery(key, retainItem, expiration, period, this.completesEventually());
    }

    private <T> ExpirableItem<T> item(Key key, boolean retain) {
        Map<Key, ExpirableItem<T>> itemMap = this.itemMap(key);
        if (retain) {
            return itemMap.get(key);
        }
        return itemMap.remove(key);
    }

    private <T> Map<Key, ExpirableItem<T>> itemMap(Key key) {
        Class<Key> keyClass = key.getClass();
        HashMap itemMap = this.getItemMap(keyClass);
        if (itemMap == null) {
            itemMap = new HashMap();
            this.putItemMap(keyClass, itemMap);
        }
        return itemMap;
    }

    private Map getItemMap(Class<Key> keyClass) {
        return this.registry.get(keyClass);
    }

    private <T> void putItemMap(Class<Key> keyClass, Map itemMap) {
        this.registry.put(keyClass, itemMap);
    }

    private <T> void manage(Key key, Item<T> item) {
        ExpirableItem<T> expiringItem = this.expiringItem(key, item);
        Map<Key, ExpirableItem<T>> itemMap = this.itemMap(expiringItem.key);
        itemMap.put(expiringItem.key, expiringItem);
        if (!expiringItem.isMaximumExpiration()) {
            this.expirableItems.add(expiringItem);
            this.scheduledSweeper.scheduleBy((ScheduledScanner.ScheduledScannable<Item>)item);
        }
    }

    private void periodicQuery(Key key, boolean retain, Period until) {
        ExpirableQuery query = this.expiringQuery(key, retain, until);
        this.expirableQueries.add(query);
        this.scheduledQueryRunnerEvictor.scheduleBy(query);
    }

    private class ScheduledSweeper
    implements ScheduledScanner<Item> {
        private Optional<Cancellable> cancellable = Optional.empty();
        private Duration currentDuration = Duration.ofMillis(Long.MAX_VALUE);

        ScheduledSweeper() {
        }

        @Override
        public void scan() {
            long millis;
            Instant now = Instant.now();
            ArrayList<ExpirableItem> confirmedExpirables = new ArrayList<ExpirableItem>();
            for (ExpirableItem expirableItem : SpaceActor.this.expirableItems) {
                if (!now.isAfter(expirableItem.expiresOn) || SpaceActor.this.itemMap(expirableItem.key).remove(expirableItem.key) == null) continue;
                confirmedExpirables.add(expirableItem);
            }
            for (ExpirableItem expirableItem : confirmedExpirables) {
                SpaceActor.this.expirableItems.remove(expirableItem);
            }
            Iterator iterator = SpaceActor.this.expirableItems.iterator();
            this.currentDuration = iterator.hasNext() ? Duration.ofMillis((millis = ((ExpirableItem)iterator.next()).expiresOn.toEpochMilli() - Instant.now().toEpochMilli()) < 0L ? 5L : millis) : SpaceActor.this.defaultScanInterval;
            this.schedule();
        }

        @Override
        public void scheduleBy(ScheduledScanner.ScheduledScannable<Item> scannable) {
            Item item = scannable.scannable();
            long rounded = item.lease.duration.toMillis() + 100L;
            if (rounded < this.currentDuration.toMillis()) {
                this.currentDuration = item.lease.duration;
                this.schedule();
            }
        }

        private void schedule() {
            this.cancellable.ifPresent(canceller -> canceller.cancel());
            this.cancellable = Optional.of(SpaceActor.this.scheduler().scheduleOnce(SpaceActor.this.scheduled, (Object)this, Duration.ZERO, this.currentDuration));
        }
    }

    private class ScheduledQueryRunnerEvictor
    implements ScheduledScanner<ExpirableQuery> {
        private Optional<Cancellable> cancellable = Optional.empty();
        private Duration currentDuration = Duration.ofMillis(Long.MAX_VALUE);

        ScheduledQueryRunnerEvictor() {
        }

        @Override
        public void scan() {
            Instant now = Instant.now();
            ArrayList<ExpirableQuery> confirmedExpirables = new ArrayList<ExpirableQuery>();
            for (ExpirableQuery expirableQuery : SpaceActor.this.expirableQueries) {
                ExpirableItem item = SpaceActor.this.item(expirableQuery.key, expirableQuery.retainItem);
                if (item != null) {
                    expirableQuery.completes.with(Optional.of(KeyItem.of(item.key, item.object, item.lease)));
                    confirmedExpirables.add(expirableQuery);
                    continue;
                }
                if (item != null || !now.isAfter(expirableQuery.expiresOn)) continue;
                confirmedExpirables.add(expirableQuery);
                expirableQuery.completes.with(Optional.empty());
            }
            for (ExpirableQuery expirableQuery : confirmedExpirables) {
                SpaceActor.this.expirableQueries.remove(expirableQuery);
            }
            Iterator iterator = SpaceActor.this.expirableQueries.iterator();
            if (iterator.hasNext()) {
                long millis = (((ExpirableQuery)iterator.next()).expiresOn.getEpochSecond() - Instant.now().getEpochSecond()) * 1000L;
                Duration minQueryDuration = Duration.ofMillis(millis < 0L ? 100L : millis);
                this.currentDuration = this.min(minQueryDuration, SpaceActor.this.defaultScanInterval);
            } else {
                this.currentDuration = SpaceActor.this.defaultScanInterval;
            }
            this.schedule();
        }

        @Override
        public void scheduleBy(ScheduledScanner.ScheduledScannable<ExpirableQuery> scannable) {
            ExpirableQuery query = scannable.scannable();
            long rounded = query.period.toMilliseconds() + 100L;
            if (rounded < this.currentDuration.toMillis()) {
                this.currentDuration = this.min(query.period.duration, SpaceActor.this.defaultScanInterval);
            }
            this.schedule();
        }

        private Duration min(Duration duration1, Duration duration2) {
            return duration1.toMillis() < duration2.toMillis() ? duration1 : duration2;
        }

        private void schedule() {
            this.cancellable.ifPresent(canceller -> canceller.cancel());
            this.cancellable = Optional.of(SpaceActor.this.scheduler().scheduleOnce(SpaceActor.this.scheduled, (Object)this, Duration.ZERO, this.currentDuration));
        }
    }
}

