/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.object;

import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.CompletionSupplier;
import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.common.Tuple2;
import io.vlingo.lattice.model.EntityActor;
import io.vlingo.lattice.model.object.ObjectTypeRegistry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.store.ListQueryExpression;
import io.vlingo.symbio.store.MapQueryExpression;
import io.vlingo.symbio.store.QueryExpression;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import io.vlingo.symbio.store.object.ObjectStoreWriter;
import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.StateSources;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class ObjectEntity<T extends StateObject>
extends EntityActor
implements ObjectStoreWriter.PersistResultInterest,
ObjectStoreReader.QueryResultInterest {
    protected final String id;
    private final ObjectTypeRegistry.Info<T> info;
    private final ObjectStoreWriter.PersistResultInterest persistResultInterest;
    private final ObjectStoreReader.QueryResultInterest queryResultInterest;
    private QueryExpression queryExpression;

    protected ObjectEntity() {
        this(null);
    }

    protected ObjectEntity(String id) {
        this.id = id != null ? id : this.address().idString();
        this.info = this.info();
        this.persistResultInterest = (ObjectStoreWriter.PersistResultInterest)this.selfAs(ObjectStoreWriter.PersistResultInterest.class);
        this.queryResultInterest = (ObjectStoreReader.QueryResultInterest)this.selfAs(ObjectStoreReader.QueryResultInterest.class);
    }

    public void start() {
        super.start();
        Tuple2 newState = this.whenNewState();
        if (newState == null) {
            this.restore(true);
        } else {
            this.apply((StateObject)newState._1, (List)newState._2, null);
        }
    }

    protected <C, RT> Completes<RT> apply(T state, List<Source<C>> sources, Metadata metadata, Supplier<RT> andThen) {
        this.stowMessages(new Class[]{ObjectStoreWriter.PersistResultInterest.class});
        this.info.store.persist(StateSources.of(state, sources), metadata, this.persistResultInterest, (Object)CompletionSupplier.supplierOrNull(andThen, (CompletesEventually)this.completesEventually()));
        return andThen == null ? null : this.completes();
    }

    protected <C, RT> Completes<RT> apply(T state, List<Source<C>> sources, Supplier<RT> andThen) {
        return this.apply(state, sources, this.metadata(), andThen);
    }

    protected <C, RT> Completes<RT> apply(T state, Source<C> source, Metadata metadata, Supplier<RT> andThen) {
        this.stowMessages(new Class[]{ObjectStoreWriter.PersistResultInterest.class});
        this.info.store.persist(StateSources.of(state, source), metadata, this.persistResultInterest, (Object)CompletionSupplier.supplierOrNull(andThen, (CompletesEventually)this.completesEventually()));
        return andThen == null ? null : this.completes();
    }

    protected <C, RT> Completes<RT> apply(T state, Source<C> source, Supplier<RT> andThen) {
        return this.apply(state, source, this.metadata(), andThen);
    }

    protected <RT> Completes<RT> apply(T state, Supplier<RT> andThen) {
        this.stowMessages(new Class[]{ObjectStoreWriter.PersistResultInterest.class});
        this.info.store.persist(StateSources.of(state), this.persistResultInterest, (Object)CompletionSupplier.supplierOrNull(andThen, (CompletesEventually)this.completesEventually()));
        return andThen == null ? null : this.completes();
    }

    protected <C> void apply(T state, List<Source<C>> sources) {
        this.apply(state, sources, this.metadata(), null);
    }

    protected <C> void apply(T state, Source<C> source) {
        this.apply(state, Arrays.asList(source), this.metadata(), null);
    }

    protected void afterApply() {
    }

    @SafeVarargs
    protected final <C> List<Source<C>> asList(Source<C> ... sources) {
        return Arrays.asList(sources);
    }

    protected String idFrom(String separator, String ... idSegments) {
        StringBuilder builder = new StringBuilder();
        builder.append(idSegments[0]);
        for (int idx = 1; idx < idSegments.length; ++idx) {
            builder.append(separator).append(idSegments[idx]);
        }
        return builder.toString();
    }

    protected Metadata metadata() {
        return Metadata.nullMetadata();
    }

    protected abstract T stateObject();

    protected abstract void stateObject(T var1);

    protected abstract Class<T> stateObjectType();

    @Override
    protected final void restore() {
        this.restore(false);
    }

    protected <C> Tuple2<T, List<Source<C>>> whenNewState() {
        return null;
    }

    public final void queryAllResultedIn(Outcome<StorageException, Result> outcome, ObjectStoreReader.QueryMultiResults results, Object object) {
        throw new UnsupportedOperationException("Must be unreachable: queryAllResultedIn()");
    }

    public final void queryObjectResultedIn(Outcome<StorageException, Result> outcome, ObjectStoreReader.QuerySingleResult queryResult, Object object) {
        outcome.andThen(result -> {
            this.stateObject((StateObject)queryResult.stateObject);
            this.disperseStowedMessages();
            return result;
        }).otherwise(cause -> {
            this.disperseStowedMessages();
            boolean ignoreNotFound = (Boolean)object;
            if (!ignoreNotFound) {
                String message = "State not restored for: " + ((Object)((Object)this)).getClass() + "(" + this.id + ") because: " + cause.result + " with: " + cause.getMessage();
                this.logger().error(message, (Throwable)cause);
                throw new IllegalStateException(message, (Throwable)cause);
            }
            return cause.result;
        });
    }

    public void persistResultedIn(Outcome<StorageException, Result> outcome, Object persistentObject, int possible, int actual, Object supplier) {
        outcome.andThen(result -> {
            this.stateObject((StateObject)persistentObject);
            this.afterApply();
            this.completeUsing(supplier);
            this.disperseStowedMessages();
            return result;
        }).otherwise(cause -> {
            this.disperseStowedMessages();
            String message = "State not preserved for: " + ((Object)((Object)this)).getClass() + "(" + this.id + ") because: " + cause.result + " with: " + cause.getMessage();
            this.logger().error(message, (Throwable)cause);
            throw new IllegalStateException(message, (Throwable)cause);
        });
    }

    private void completeUsing(Object supplier) {
        if (supplier != null) {
            ((CompletionSupplier)supplier).complete();
        }
    }

    private ObjectTypeRegistry.Info<T> info() {
        try {
            ObjectTypeRegistry registry = (ObjectTypeRegistry)this.stage().world().resolveDynamic(ObjectTypeRegistry.INTERNAL_NAME, ObjectTypeRegistry.class);
            ObjectTypeRegistry.Info info = registry.info(this.stateObjectType());
            return info;
        }
        catch (Exception e) {
            String message = ((Object)((Object)this)).getClass().getSimpleName() + ": Info not registered with ObjectTypeRegistry.";
            this.logger().error(message);
            throw new IllegalStateException(message);
        }
    }

    private QueryExpression queryExpression() {
        if (this.queryExpression == null) {
            if (this.info.queryObjectExpression.isListQueryExpression()) {
                this.queryExpression = ListQueryExpression.using((Class)this.info.queryObjectExpression.type, (String)this.info.queryObjectExpression.query, (List)this.stateObject().queryList());
            } else if (this.info.queryObjectExpression.isMapQueryExpression()) {
                this.queryExpression = MapQueryExpression.using((Class)this.info.queryObjectExpression.type, (String)this.info.queryObjectExpression.query, (Map)this.stateObject().queryMap());
            } else {
                throw new IllegalStateException("Unknown QueryExpression type: " + this.queryExpression);
            }
        }
        return this.queryExpression;
    }

    private void restore(boolean ignoreNotFound) {
        this.stowMessages(new Class[]{ObjectStoreReader.QueryResultInterest.class});
        this.info.store.queryObject(this.queryExpression(), this.queryResultInterest, (Object)ignoreNotFound);
    }
}

