/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.object;

import io.vlingo.actors.World;
import io.vlingo.symbio.store.QueryExpression;
import io.vlingo.symbio.store.object.ObjectStore;
import io.vlingo.symbio.store.object.StateObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class ObjectTypeRegistry {
    static final String INTERNAL_NAME = UUID.randomUUID().toString();
    private final Map<Class<?>, Info<?>> stores = new HashMap();

    public ObjectTypeRegistry(World world) {
        world.registerDynamic(INTERNAL_NAME, (Object)this);
    }

    public <T> Info<T> info(Class<?> type) {
        return this.stores.get(type);
    }

    public ObjectTypeRegistry register(Info<?> info) {
        this.stores.put(info.storeType, info);
        return this;
    }

    public static class Info<T> {
        public final StateObjectMapper mapper;
        public final QueryExpression queryObjectExpression;
        public final ObjectStore store;
        public final String storeName;
        public final Class<T> storeType;

        public Info(ObjectStore store, Class<T> storeType, String storeName, QueryExpression queryObjectExpression, StateObjectMapper mapper) {
            this.store = store;
            this.storeType = storeType;
            this.storeName = storeName;
            this.queryObjectExpression = queryObjectExpression;
            this.mapper = mapper;
        }
    }
}

