/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.process;

import io.vlingo.lattice.model.Command;
import io.vlingo.lattice.model.DomainEvent;
import io.vlingo.symbio.Source;
import java.util.ArrayList;
import java.util.List;

public class ProcessMessage
extends Source<ProcessMessage> {
    public Source<?> source;

    public static <C> List<Source<ProcessMessage>> wrap(List<Source<C>> sources) {
        boolean reuse = !sources.isEmpty() && sources.get(0).getClass() == ProcessMessage.class;
        ArrayList<Source<ProcessMessage>> messages = new ArrayList<Source<ProcessMessage>>(sources.size());
        for (Source<C> source : sources) {
            if (reuse) {
                messages.add((ProcessMessage)source);
                continue;
            }
            ProcessMessage message = new ProcessMessage(source);
            messages.add(message);
        }
        return messages;
    }

    public ProcessMessage(Command command) {
        this.source = command;
    }

    public ProcessMessage(DomainEvent event) {
        this.source = event;
    }

    public ProcessMessage(Source<?> source) {
        this.source = source;
    }

    public ProcessMessage() {
        this.source = null;
    }

    public String id() {
        return this.source.id();
    }

    public Class<?> sourceType() {
        return this.source.getClass();
    }

    public String sourceTypeName() {
        return this.source.getClass().getName();
    }

    public <T extends Source<?>> T typedSource() {
        return (T)this.source;
    }
}

