/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.process;

import io.vlingo.common.serialization.JsonSerialization;
import io.vlingo.lattice.model.process.ProcessMessage;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.EntryAdapter;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;

public class ProcessMessageTextAdapter
implements EntryAdapter<ProcessMessage, BaseEntry.TextEntry> {
    public ProcessMessage fromEntry(BaseEntry.TextEntry entry) {
        try {
            SerializableProcessMessage serializedMessage = (SerializableProcessMessage)JsonSerialization.deserialized((String)((String)entry.entryData()), SerializableProcessMessage.class);
            Class<?> sourceType = Class.forName(serializedMessage.type);
            Source source = (Source)JsonSerialization.deserialized((String)serializedMessage.source, sourceType);
            return new ProcessMessage(source);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ProcessMessageTextAdapter failed because: " + e.getMessage(), e);
        }
    }

    public BaseEntry.TextEntry toEntry(ProcessMessage source, Metadata metadata) {
        SerializableProcessMessage serializedMessage = new SerializableProcessMessage(source);
        String serialization = JsonSerialization.serialized((Object)serializedMessage);
        return new BaseEntry.TextEntry(ProcessMessage.class, 1, serialization, metadata);
    }

    public BaseEntry.TextEntry toEntry(ProcessMessage source, String id, Metadata metadata) {
        SerializableProcessMessage serializedMessage = new SerializableProcessMessage(source);
        String serialization = JsonSerialization.serialized((Object)serializedMessage);
        return new BaseEntry.TextEntry(id, ProcessMessage.class, 1, serialization, metadata);
    }

    public BaseEntry.TextEntry toEntry(ProcessMessage source, int version, String id, Metadata metadata) {
        SerializableProcessMessage serializedMessage = new SerializableProcessMessage(source);
        String serialization = JsonSerialization.serialized((Object)serializedMessage);
        return new BaseEntry.TextEntry(id, ProcessMessage.class, 1, serialization, version, metadata);
    }

    private static final class SerializableProcessMessage {
        public final String source;
        public final String type;

        SerializableProcessMessage(ProcessMessage message) {
            this.source = this.sourceToText(message.source);
            this.type = message.sourceTypeName();
        }

        private String sourceToText(Source<?> source) {
            String sourceJson = JsonSerialization.serialized(source);
            return sourceJson;
        }
    }
}

